package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public record SimpleDropProvider(List<SimpleDrop> drops) implements ItemDropProvider {

    public static final MapCodec<SimpleDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            MapCodecs.flexibleList(SimpleDrop.CODEC.codec()).fieldOf("items").forGetter(SimpleDropProvider::drops)
    ).apply(instance, SimpleDropProvider::new));

    public static final class_9139<class_9129, SimpleDropProvider> STREAM = class_9139.method_56437(
            (buffer, value) -> {
                buffer.method_53002(value.drops.size());
                for (SimpleDrop drop : value.drops) {
                    SimpleDrop.STREAM.encode(buffer, drop);
                }
            },
            (buffer) -> {
                final int size = buffer.readInt();
                final List<SimpleDrop> drops = new LinkedList<>();
                for (int i = 0; i < size; i++) {
                    drops.add(SimpleDrop.STREAM.decode(buffer));
                }
                return new SimpleDropProvider(drops);
            });

    @Override
    public void apply(BotanyPotContext context, class_1937 level, Consumer<class_1799> drops) {
        for (SimpleDrop drop : this.drops) {
            if (MathsHelper.percentChance(drop.chance)) {
                drops.accept(drop.drop().method_7972());
            }
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return ItemDropProviderType.SIMPLE_DROPS;
    }

    @Override
    public List<class_1799> getDisplayItems() {
        return this.drops.stream().map(d -> d.drop).collect(Collectors.toList());
    }

    public record SimpleDrop(class_1799 drop, float chance) {
        public static final MapCodec<SimpleDrop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                class_1799.field_24671.fieldOf("result").forGetter(SimpleDrop::drop),
                Codec.floatRange(0f, 1f).optionalFieldOf("chance", 1f).forGetter(SimpleDrop::chance)
        ).apply(instance, SimpleDrop::new));
        public static final class_9139<class_9129, SimpleDrop> STREAM = class_9139.method_56435(class_1799.field_48349, SimpleDrop::drop, class_9135.field_48552, SimpleDrop::chance, SimpleDrop::new);
    }
}