package net.darkhax.botanypots.common.impl.block.menu;

import net.darkhax.bookshelf.common.api.function.SidedReloadableCache;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_8786;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class BotanyPotScreen extends class_465<BotanyPotMenu> {

    private static final class_2960 RECIPE_BUTTON_LOCATION = BotanyPotsMod.id("textures/gui/recipe_button.png");
    private final class_2960 backgroundTexture;

    public BotanyPotScreen(BotanyPotMenu menu, class_1661 playerInv, class_2561 name) {
        super(menu, playerInv, name);
        this.backgroundTexture = BotanyPotsMod.id("textures/gui/container/" + (menu.isHopper ? "hopper_botany_pot_gui.png" : "botany_pot_gui.png"));
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int recipeOffset = this.field_2776 + (this.field_2797.isHopper ? 13 : 33);
    }

    @Override
    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        graphics.method_25302(this.backgroundTexture, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(graphics, mouseX, mouseY, tickDelta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    @NotNull
    @Override
    protected List<class_2561> method_51454(@NotNull class_1799 stack) {
        final List<class_2561> tooltips = super.method_51454(stack);
        final BlockEntityContext context = this.field_2797.getContext();
        if (context != null) {
            if (stack == this.field_2797.method_7602().get(BotanyPotBlockEntity.SOIL_SLOT)) {
                stack = context.method_59984(BotanyPotBlockEntity.SOIL_SLOT);
            }
            else if (stack == this.field_2797.method_7602().get(BotanyPotBlockEntity.SEED_SLOT)) {
                stack = context.method_59984(BotanyPotBlockEntity.SEED_SLOT);
            }
            final class_1937 level = context.pot().method_10997();
            if (!addComponentTooltip(SoilOverride.TYPE.get(), SoilOverride::soil, stack, context, level, tooltips)) {
                addRecipeTooltips(Soil.CACHE, stack, context, level, tooltips);
            }
            if (!addComponentTooltip(CropOverride.TYPE.get(), CropOverride::crop, stack, context, level, tooltips)) {
                addRecipeTooltips(Crop.CACHE, stack, context, level, tooltips);
            }
            addRecipeTooltips(Fertilizer.CACHE, stack, context, level, tooltips);
            addRecipeTooltips(PotInteraction.CACHE, stack, context, level, tooltips);
            if (stack.method_31573(BotanyPotMenu.HARVEST_ITEM) && level != null) {
                final float modifier = Helpers.efficiencyModifier(level.method_30349(), stack);
                if (modifier != 0f) {
                    tooltips.add(Helpers.modifierComponent(Helpers.GROWTH_MODIFIER_KEY, modifier));
                }
            }
        }
        return tooltips;
    }

    private static <T extends BotanyPotRecipe, W> boolean addComponentTooltip(class_9331<W> componentType, Function<W, T> func, class_1799 stack, BlockEntityContext context, class_1937 level, List<class_2561> tooltips) {
        if (stack.method_57826(componentType)) {
            func.apply(stack.method_57824(componentType)).hoverTooltip(stack, context, level, tooltips::add);
            return true;
        }
        return false;
    }

    private static <T extends BotanyPotRecipe> void addRecipeTooltips(SidedReloadableCache<RecipeCache<T>> cache, class_1799 stack, BlockEntityContext context, class_1937 level, List<class_2561> tooltips) {
        final class_8786<T> recipe = Objects.requireNonNull(cache.apply(level)).lookup(stack, context, level);
        if (recipe != null) {
            recipe.comp_1933().hoverTooltip(stack, context, level, tooltips::add);
        }
    }
}