package net.darkhax.botanypots.common.impl.data.growthamount;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmount;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmountType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;

public record RangedGrowthAmount(int min, int max) implements GrowthAmount {

    public static final class_2960 ID = BotanyPotsMod.id("ranged");
    public static final Supplier<GrowthAmountType<?>> TYPE = GrowthAmountType.getLazy(ID);
    public static final MapCodec<RangedGrowthAmount> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.intRange(0, Integer.MAX_VALUE).fieldOf("min").forGetter(RangedGrowthAmount::min),
            Codec.intRange(0, Integer.MAX_VALUE).fieldOf("max").forGetter(RangedGrowthAmount::max)
    ).apply(instance, RangedGrowthAmount::new));
    public static final class_9139<class_9129, RangedGrowthAmount> STREAM = class_9139.method_56435(class_9135.field_49675, RangedGrowthAmount::min, class_9135.field_49675, RangedGrowthAmount::max, RangedGrowthAmount::new);

    @Override
    public int getAmount(@NotNull BotanyPotContext context, @NotNull class_1937 level) {
        return MathsHelper.nextInt(level.field_9229, this.min, this.max);
    }

    @Override
    public GrowthAmountType<?> getType() {
        return TYPE.get();
    }
}
