/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.config.Config;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Helpers {
    public static final Codec<class_2248> BLOCK_CODEC = class_2960.field_25139.xmap(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0));
    public static final class_9139<ByteBuf, class_2248> BLOCK_STREAM = class_2960.field_48267.method_56432(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41175).method_10221(arg_0));
    public static final Codec<class_1792> ITEM_CODEC = class_2960.field_25139.xmap(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0));
    public static final class_9139<ByteBuf, class_1792> ITEM_STREAM = class_2960.field_48267.method_56432(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0));
    public static final Codec<class_1299<?>> ENTITY_TYPE_CODEC = class_2960.field_25139.xmap(arg_0 -> ((class_7922)class_7923.field_41177).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0));
    public static final class_9139<ByteBuf, class_1299<?>> ENTITY_TYPE_STREAM = class_2960.field_48267.method_56432(arg_0 -> ((class_7922)class_7923.field_41177).method_10223(arg_0), arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0));
    public static final class_9139<ByteBuf, class_2680> BLOCK_STATE_STREAM = class_9135.method_56371((class_2359)class_2248.field_10651);
    public static final class_9139<class_9129, Optional<class_1856>> OPTIONAL_INGREDIENT_STREAM = DataHelper.optionalStream((class_9139)StreamCodecs.INGREDIENT_NON_EMPTY);
    public static final class_9139<class_9129, Optional<class_1799>> OPTIONAL_ITEMSTACK_STREAM = DataHelper.optionalStream((class_9139)class_1799.field_48349);
    public static final class_9139<class_9129, Optional<class_4550>> OPTIONAL_BLOCK_PREDICATE = DataHelper.optionalStream((class_9139)class_4550.field_49181);
    public static final class_9139<ByteBuf, class_6862<class_2248>> BLOCK_TAG = class_2960.field_48267.method_56432(rl -> class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)rl), class_6862::comp_327);
    public static final class_6862<class_1887> INCREASE_POT_GROWTH_TAG = class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)BotanyPotsMod.id("increase_pot_growth"));
    public static final class_6862<class_1887> NEGATE_HARVEST_DAMAGE_TAG = class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)BotanyPotsMod.id("negate_harvest_damage"));
    public static final Supplier<class_6880<class_1320>> GROWTH_MOD_ATTRIBUTE = CachedSupplier.cache(() -> (class_6880)class_7923.field_41190.method_55841(BotanyPotsMod.id("growth")).orElseThrow());
    public static final String GROWTH_MODIFIER_KEY = "tooltip.botanypots.growth_modifier";
    public static final Supplier<class_6880<class_1320>> YIELD_MOD_ATTRIBUTE = CachedSupplier.cache(() -> (class_6880)class_7923.field_41190.method_55841(BotanyPotsMod.id("yield")).orElseThrow());
    public static final String YIELD_MODIFIER_KEY = "tooltip.botanypots.yield_modifier";

    public static class_2561 modifierComponent(String key, float modifier) {
        if (modifier > 0.0f) {
            return class_2561.method_43469((String)key, (Object[])new Object[]{"+" + MathsHelper.DECIMAL_2.format((double)modifier * 100.0) + "%"}).method_27692(class_124.field_1078);
        }
        return class_2561.method_43469((String)key, (Object[])new Object[]{"-" + MathsHelper.DECIMAL_2.format((double)modifier * 100.0) + "%"}).method_27692(class_124.field_1061);
    }

    public static class_2561 indent(class_2561 base) {
        return class_2561.method_43470((String)"  ").method_10852(base);
    }

    public static int getRequiredGrowthTicks(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        BlockEntityContext beContext;
        class_2248 class_22482;
        float cropTime = crop.getRequiredGrowthTicks(context, level);
        float growthModifier = ((Config)BotanyPotsMod.CONFIG.get()).gameplay.global_growth_modifier;
        growthModifier += soil != null ? soil.getGrowthModifier(context, level) : 0.0f;
        growthModifier += Helpers.efficiencyModifier(level.method_30349(), context.getHarvestItem());
        if (context instanceof BlockEntityContext && (class_22482 = (beContext = (BlockEntityContext)context).pot().method_11010().method_26204()) instanceof BotanyPotBlock) {
            BotanyPotBlock potBlock = (BotanyPotBlock)class_22482;
            growthModifier += potBlock.getGrowthModifier(context, level, crop, soil);
        }
        return class_3532.method_15375((float)(cropTime / growthModifier));
    }

    public static float getTotalYield(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        BlockEntityContext beContext;
        class_2248 class_22482;
        float yieldScale = crop.getYieldScale(context, level);
        float yield = crop.getBaseYield(context, level);
        if (context instanceof BlockEntityContext && (class_22482 = (beContext = (BlockEntityContext)context).pot().method_11010().method_26204()) instanceof BotanyPotBlock) {
            BotanyPotBlock potBlock = (BotanyPotBlock)class_22482;
            yield += yieldScale * potBlock.getYieldModifier(context, level, crop, soil);
        }
        if (soil != null) {
            yield += yieldScale * soil.getYieldModifier(context, level);
        }
        return yield += yieldScale * (float)Helpers.getAttributeValue(YIELD_MOD_ATTRIBUTE.get(), context.getHarvestItem(), 0.0f);
    }

    public static int getLootRolls(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        return Helpers.determineRollCount(Helpers.getTotalYield(context, level, crop, soil), level.method_8409());
    }

    public static int determineRollCount(float chance, class_5819 rng) {
        int guaranteedRolls = (int)Math.floor(chance);
        float remainingChance = chance % 1.0f;
        if (rng.method_43057() < remainingChance) {
            ++guaranteedRolls;
        }
        return Math.max(0, guaranteedRolls);
    }

    public static int chanceToInt(float chance) {
        return (int)Math.floor(chance * 100.0f);
    }

    public static class_5250 withScale(class_5250 base, float scale) {
        if (scale != 1.0f) {
            base.method_27693(" (").method_10852((class_2561)class_2561.method_43469((String)"tooltip.botanypots.percent", (Object[])new Object[]{Helpers.chanceToInt(scale)}).method_27692(scale > 1.0f ? class_124.field_1060 : class_124.field_1061)).method_27693(")");
        }
        return base;
    }

    public static float efficiencyModifier(class_5455 registryAccess, class_1799 stack) {
        float modifier = 0.0f;
        modifier += (float)EnchantmentLevel.HIGHEST.get(INCREASE_POT_GROWTH_TAG, stack) * ((Config)BotanyPotsMod.CONFIG.get()).gameplay.efficiency_growth_modifier;
        return modifier += (float)Helpers.getAttributeValue(GROWTH_MOD_ATTRIBUTE.get(), stack, 0.0f);
    }

    public static double getAttributeValue(class_6880<class_1320> attribute, class_1799 stack, float defaultValue) {
        double value = 0.0;
        class_9285 modifiers = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            if (entry.comp_2395() != attribute) continue;
            double entryAmount = entry.comp_2396().comp_2449();
            value += (switch (entry.comp_2396().comp_2450()) {
                default -> throw new MatchException(null, null);
                case class_1322.class_1323.field_6328 -> entryAmount;
                case class_1322.class_1323.field_6330 -> entryAmount * (double)defaultValue;
                case class_1322.class_1323.field_6331 -> entryAmount * value;
            });
        }
        return value;
    }
}

