/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;

public class InvalidCrops {
    private static final CachedSupplier<class_2248> potBlockType = CachedSupplier.of((class_2378)class_7923.field_41175, (class_2960)BotanyPotsMod.id("terracotta_hopper_botany_pot"));

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        LiteralArgumentBuilder cmd = class_2170.method_9247((String)"check_crops");
        cmd.executes(InvalidCrops::execute);
        parent.then((ArgumentBuilder)cmd);
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338 targetPos = ((class_2168)ctx.getSource()).method_9229().method_23312();
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        level.method_8652(targetPos, ((class_2248)potBlockType.get()).method_9564(), 3);
        BotanyPotBlockEntity potEntity = (BotanyPotBlockEntity)level.method_8321(targetPos);
        if (potEntity == null) {
            throw new IllegalStateException("Test pot was null!");
        }
        Set crops = Objects.requireNonNull((RecipeCache)Crop.CACHE.apply((class_1937)((class_2168)ctx.getSource()).method_9225())).getCachedValues().entries().stream().sorted(Comparator.comparing(s -> class_7923.field_41178.method_10221((Object)((class_1792)s.getKey())).toString())).collect(Collectors.toCollection(LinkedHashSet::new));
        List<class_1799> toolList = InvalidCrops.buildToolList(((class_2168)ctx.getSource()).method_30497());
        int errorCount = 0;
        block0: for (Map.Entry cropEntry : crops) {
            Crop crop = (Crop)((class_8786)cropEntry.getValue()).comp_1933();
            potEntity.method_5448();
            class_1799 firstSoil = InvalidCrops.findFirstSoil(crop);
            if (firstSoil.method_7960()) {
                BotanyPotsMod.LOG.error("Could not find a valid soil for crop '{}'!", (Object)((class_8786)cropEntry.getValue()).comp_1932());
                ++errorCount;
                continue;
            }
            potEntity.method_5447(0, InvalidCrops.findFirstSoil(crop));
            potEntity.method_5447(1, ((class_1792)cropEntry.getKey()).method_7854());
            for (class_1799 tool : toolList) {
                potEntity.method_5447(2, tool.method_7972());
                ArrayList items = new ArrayList();
                for (int i = 0; i < 1000; ++i) {
                    potEntity.updateGrowthTime(potEntity.getRequiredGrowthTicks());
                    crop.onHarvest(potEntity.getRecipeContext(), (class_1937)level, items::add);
                    if (!items.isEmpty()) continue block0;
                }
            }
            ++errorCount;
            BotanyPotsMod.LOG.error("Crop '{}' did not drop any items!", (Object)((class_8786)cropEntry.getValue()).comp_1932());
        }
        if (errorCount > 0) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.botanypots.debug.crop_errors", (Object[])new Object[]{crops.size(), errorCount}));
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.botanypots.debug.crop_success", (Object[])new Object[]{crops.size()}), false);
        }
        return errorCount;
    }

    private static class_1799 findFirstSoil(Crop crop) {
        if (crop instanceof BasicCrop) {
            BasicCrop basic = (BasicCrop)crop;
            for (class_1792 item : class_7923.field_41178) {
                class_1799 stack = item.method_7854();
                if (!basic.getBasicProperties().soil().method_8093(stack)) continue;
                return stack;
            }
        }
        return class_1799.field_8037;
    }

    private static List<class_1799> buildToolList(class_5455 registries) {
        ArrayList<class_1799> tools = new ArrayList<class_1799>();
        tools.add(class_1799.field_8037);
        tools.add(InvalidCrops.withSilkTouch(class_1802.field_8868, registries));
        tools.add(InvalidCrops.withSilkTouch(class_1802.field_22026, registries));
        tools.add(InvalidCrops.withSilkTouch(class_1802.field_22024, registries));
        tools.add(InvalidCrops.withSilkTouch(class_1802.field_22025, registries));
        tools.add(InvalidCrops.withSilkTouch(class_1802.field_22022, registries));
        tools.add(InvalidCrops.withSilkTouch(class_1802.field_22023, registries));
        return tools;
    }

    private static class_1799 withSilkTouch(class_1792 item, class_5455 registries) {
        class_1799 stack = item.method_7854();
        stack.method_7978((class_6880)registries.method_30530(class_7924.field_41265).method_40264(class_1893.field_9099).orElseThrow(), 1);
        return stack;
    }
}

