package net.darkhax.botanypots.common.api.data.components;

import com.mojang.serialization.Codec;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import java.util.Optional;

/**
 * This item component allows specific items to define a soil that differs from their default recipe-based behavior. For
 * example, a specific iron block could grow crops at 10x speed while normal iron blocks do not offer any speed
 * modifier.
 *
 * @param soil The soil to use instead of the default recipe-based lookup.
 */
public record SoilOverride(Soil soil) {

    public static final Codec<SoilOverride> CODEC = BotanyPotRecipe.recipeCodec(Soil.TYPE).xmap(SoilOverride::new, SoilOverride::soil);
    public static final class_9139<class_9129, SoilOverride> STREAM = BotanyPotRecipe.recipeStream(Soil.TYPE).method_56432(SoilOverride::new, SoilOverride::soil);
    public static final class_2960 TYPE_ID = BotanyPotsMod.id("soil");
    public static final CachedSupplier<class_9331<SoilOverride>> TYPE = CachedSupplier.of(class_7923.field_49658, TYPE_ID).cast();

    /**
     * Gets the override value for an item if one exists.
     *
     * @param stack The item to query.
     * @return The current soil override as an optional. If an override is specified the optional will be present,
     * otherwise it is empty.
     */
    public static Optional<SoilOverride> get(class_1799 stack) {
        return stack.method_57826(TYPE.get()) ? Optional.ofNullable(stack.method_57824(TYPE.get())) : Optional.empty();
    }

    /**
     * Applies a soil override to the specified item.
     *
     * @param stack The item to apply the override to.
     * @param soil  The soil to attach as an override.
     */
    public static void set(class_1799 stack, Soil soil) {
        stack.method_57379(TYPE.get(), new SoilOverride(soil));
    }
}