package net.darkhax.botanypots.common.impl.data.display.renderer;

import net.darkhax.bookshelf.common.api.util.IRenderHelper;
import net.darkhax.botanypots.common.api.data.display.math.TintColor;
import net.darkhax.botanypots.common.api.data.display.render.AbstractDisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.RenderOptions;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.display.types.TexturedCubeDisplayState;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public final class TexturedCubeStateRenderer extends AbstractDisplayRenderer<TexturedCubeDisplayState, RenderOptions> {

    private static final int[] WHITE = {255, 255, 255, 255};
    public static final TexturedCubeStateRenderer RENDERER = new TexturedCubeStateRenderer();

    @Override
    public RenderOptions getRenderOptions(TexturedCubeDisplayState display) {
        return display.renderOptions();
    }

    @Override
    public void render(class_5614.class_5615 context, TexturedCubeDisplayState display, RenderOptions renderOptions, class_4587 pose, class_1937 level, class_2338 pos, float tickDelta, class_4597 bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float growthScale, float heightOffset) {
        IRenderHelper.GET.renderBox(bufferSource.getBuffer(class_1921.method_23583()), pose, IRenderHelper.GET.blockSprite(display.getTexture()), light, overlay, display.renderOptions().getColor().orElse(TintColor.WHITE).asArray());
    }
}