package net.darkhax.botanypots.common.impl.block.entity;

import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2158;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.stream.IntStream;

public abstract class AbstractBotanyPotBlockEntity extends class_2621 implements class_1278 {

    public static final int SOIL_SLOT = 0;
    public static final int SEED_SLOT = 1;
    public static final int TOOL_SLOT = 2;
    public static final int SLOT_COUNT = 15;
    public static final int[] STORAGE_SLOTS = IntStream.range(3, SLOT_COUNT).toArray();
    public static final int[] EMPTY_SLOTS = new int[0];
    public static final class_2561 DEFAULT_NAME = class_2561.method_43471("container.botanypots.botany_pot");

    private class_2371<class_1799> items = class_2371.method_10213(SLOT_COUNT, class_1799.field_8037);
    protected CachedSupplier<class_2338> below;
    protected CachedSupplier<PotType> potType;

    public abstract void onSoilChanged(class_1799 newStack);

    public abstract void onSeedChanged(class_1799 newStack);

    public abstract void onToolChanged(class_1799 newStack);

    protected AbstractBotanyPotBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.below = CachedSupplier.cache(() -> this.method_11016().method_10074());
        this.potType = CachedSupplier.cache(() -> ((BotanyPotBlock) this.method_11010().method_26204()).type);
    }

    public PotType getPotType() {
        return this.potType.get();
    }

    public boolean isHopper() {
        return this.potType.get() == PotType.HOPPER;
    }

    public class_1799 getSoilItem() {
        return this.items.get(SOIL_SLOT);
    }

    public void setSoilItem(class_1799 newSoil) {
        this.method_5447(SOIL_SLOT, newSoil);
    }

    public class_1799 getSeedItem() {
        return this.items.get(SEED_SLOT);
    }

    public void setSeed(class_1799 newSeed) {
        this.method_5447(SEED_SLOT, newSeed);
    }

    public class_1799 getHarvestItem() {
        return this.method_5438(TOOL_SLOT);
    }

    public void setHoe(class_1799 hoeStack) {
        this.method_5447(TOOL_SLOT, hoeStack);
    }

    public void runFunction(class_2960 functionId) {
        if (this.field_11863 instanceof class_3218 serverLevel) {
            final Optional<class_2158<class_2168>> function = serverLevel.method_8503().method_3740().method_12905(functionId);
            final class_2168 sourceStack = this.createCommandSourceStack();
            if (sourceStack != null) {
                function.ifPresentOrElse(func -> serverLevel.method_8503().method_3740().method_12904(func, sourceStack), () -> BotanyPotsMod.LOG.error("Pot at {} tried to run missing function {}. This is an issue with your datapacks.", this.field_11867, functionId));
            }
        }
    }

    @Nullable
    public class_2168 createCommandSourceStack() {
        if (this.field_11863 instanceof class_3218 serverLevel) {
            final class_2350 direction = this.method_11010().method_11654(class_2741.field_12481);
            final class_2561 name = this.method_5477();
            return new class_2168(class_2165.field_17395, class_243.method_24953(this.field_11867), new class_241(0f, direction.method_10144()), serverLevel, 2, name.getString(), name, serverLevel.method_8503(), null);
        }
        return null;
    }

    @Override
    public void method_11014(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.items = class_2371.method_10213(this.method_5439(), class_1799.field_8037);
        if (!this.method_54871(tag)) {
            class_1262.method_5429(tag, this.items, registries);
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (!this.method_54872(tag)) {
            class_1262.method_5426(tag, this.items, registries);
        }
    }

    public void markUpdated() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    @Override
    public void method_5447(int slotId, @NotNull class_1799 stack) {
        super.method_5447(slotId, stack);
        if (slotId == SOIL_SLOT) {
            this.onSoilChanged(stack);
        }
        else if (slotId == SEED_SLOT) {
            this.onSeedChanged(stack);
        }
        else if (slotId == TOOL_SLOT) {
            this.onToolChanged(stack);
        }
    }

    @Override
    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return side == class_2350.field_11033 ? STORAGE_SLOTS : EMPTY_SLOTS;
    }

    @Override
    public boolean method_5492(int slot, @NotNull class_1799 stack, @Nullable class_2350 side) {
        // Botany Pots only allow extracting items via automation.
        return false;
    }

    @Override
    public boolean method_5493(int slot, @NotNull class_1799 stack, @NotNull class_2350 side) {
        // Only storage slots (2-13) can be extracted, and only from the bottom face.
        return side == class_2350.field_11033 && this.isHopper() && slot > TOOL_SLOT && slot < SLOT_COUNT;
    }

    @NotNull
    @Override
    protected class_2561 method_17823() {
        return DEFAULT_NAME;
    }

    @NotNull
    @Override
    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    @Override
    protected void method_11281(@NotNull class_2371<class_1799> newItems) {
        this.items = newItems;
    }

    @Override
    public int method_5439() {
        return SLOT_COUNT;
    }
}