/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.fertilizer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.FunctionHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.SoundEffect;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmount;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmountType;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class BasicFertilizer
extends Fertilizer
implements CacheableRecipe {
    public static final MapCodec<BasicFertilizer> CODEC = Properties.CODEC.xmap(BasicFertilizer::new, BasicFertilizer::getProperties);
    public static final class_9139<class_9129, BasicFertilizer> STREAM = Properties.STREAM.method_56432(BasicFertilizer::new, BasicFertilizer::getProperties);
    public static final class_1865<BasicFertilizer> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    private final Properties properties;

    public BasicFertilizer(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void apply(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        BlockEntityContext context;
        if (input instanceof BlockEntityContext && (context = (BlockEntityContext)input).pot().canBonemeal() && level instanceof class_3218) {
            class_3218 sLevel = (class_3218)level;
            int requiredGrowthTicks = context.getRequiredGrowthTicks();
            int maxBonemealableTicks = requiredGrowthTicks - 20;
            if (requiredGrowthTicks > 20 && context.pot().growthTime.getTicks() < (float)maxBonemealableTicks) {
                context.pot().growthTime.setTicks(Math.min(context.pot().growthTime.getTicks() + (float)this.properties.growthAmount.getAmount(context, level), (float)maxBonemealableTicks));
                context.pot().setBonemealCooldown(this.properties.cooldown);
                if (this.properties.spawnsParticles) {
                    level.method_20290(2011, context.pot().method_11016(), 15);
                }
                if (this.properties.notifySculk) {
                    level.method_33596((class_1297)context.getPlayer(), (class_6880)class_5712.field_28733, context.pot().method_11016());
                }
                if (!Objects.requireNonNull(context.player()).method_7337()) {
                    context.getInteractionItem().method_7934(1);
                }
                this.properties.soundEffect.ifPresent(soundEffect -> soundEffect.playSound(sLevel, null, context.pot().method_11016()));
                context.pot().markUpdated();
            }
        }
    }

    public boolean matches(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        return this.properties.heldItem.method_8093(input.getInteractionItem()) && FunctionHelper.test(this.properties.soilIngredient, i -> i.method_8093(input.getSoilItem())) && FunctionHelper.test(this.properties.seedIngredient, i -> i.method_8093(input.getSeedItem()));
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(class_1799 stack) {
        return this.properties.heldItem.method_8093(stack);
    }

    @NotNull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level) {
        return this.properties.heldItem.method_8093(candidate);
    }

    public record Properties(class_1856 heldItem, Optional<class_1856> soilIngredient, Optional<class_1856> seedIngredient, GrowthAmount growthAmount, int cooldown, boolean spawnsParticles, boolean notifySculk, Optional<SoundEffect> soundEffect) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("held_item").forGetter(Properties::heldItem), (App)class_1856.field_46095.optionalFieldOf("soil_item").forGetter(Properties::soilIngredient), (App)class_1856.field_46095.optionalFieldOf("seed_item").forGetter(Properties::seedIngredient), (App)GrowthAmountType.GROWTH_AMOUNT_CODEC.fieldOf("growth").forGetter(Properties::growthAmount), (App)Codec.INT.optionalFieldOf("cooldown", (Object)20).forGetter(Properties::cooldown), (App)Codec.BOOL.optionalFieldOf("spawn_particles", (Object)true).forGetter(Properties::spawnsParticles), (App)Codec.BOOL.optionalFieldOf("notify_sculk", (Object)true).forGetter(Properties::notifySculk), (App)SoundEffect.CODEC.codec().optionalFieldOf("sound_effect").forGetter(Properties::soundEffect)).apply((Applicative)instance, Properties::new));
        public static final class_9139<class_9129, Properties> STREAM = new class_9139<class_9129, Properties>(){

            @NotNull
            public Properties decode(@NotNull class_9129 buf) {
                class_1856 heldItem = (class_1856)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                Optional soil = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                Optional seed = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                GrowthAmount growth = (GrowthAmount)GrowthAmountType.GROWTH_AMOUNT_STREAM.decode((Object)buf);
                int cooldown = (Integer)class_9135.field_49675.decode((Object)buf);
                boolean particles = buf.readBoolean();
                boolean sculk = buf.readBoolean();
                Optional soundEffect = (Optional)SoundEffect.OPTIONAL_STREAM.decode((Object)buf);
                return new Properties(heldItem, soil, seed, growth, cooldown, particles, sculk, soundEffect);
            }

            public void encode(@NotNull class_9129 buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.heldItem);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.soilIngredient);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.seedIngredient);
                GrowthAmountType.GROWTH_AMOUNT_STREAM.encode((Object)buf, (Object)properties.growthAmount);
                class_9135.field_49675.encode((Object)buf, (Object)properties.cooldown);
                buf.method_52964(properties.spawnsParticles);
                buf.method_52964(properties.notifySculk);
                SoundEffect.OPTIONAL_STREAM.encode((Object)buf, properties.soundEffect);
            }
        };
    }
}

