/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.interaction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.data.SoundEffect;
import net.darkhax.botanypots.common.api.data.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.CacheableRecipe;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import org.jetbrains.annotations.NotNull;

public class BasicPotInteraction
extends PotInteraction
implements CacheableRecipe {
    public static final MapCodec<BasicPotInteraction> CODEC = Properties.CODEC.xmap(BasicPotInteraction::new, BasicPotInteraction::getProperties);
    public static final class_9139<class_9129, BasicPotInteraction> STREAM = Properties.STREAM.method_56432(BasicPotInteraction::new, BasicPotInteraction::getProperties);
    public static final class_1865<BasicPotInteraction> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    public final Properties properties;

    public BasicPotInteraction(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void apply(@NotNull BotanyPotContext context) {
        class_3222 player;
        BlockEntityContext input;
        class_1657 class_16572;
        if (context instanceof BlockEntityContext && (class_16572 = (input = (BlockEntityContext)context).player()) instanceof class_3222 && (class_16572 = (player = (class_3222)class_16572).method_37908()) instanceof class_3218) {
            class_3218 level = (class_3218)class_16572;
            this.properties.newSoil.ifPresent(soilStack -> {
                Services.GAMEPLAY.dropRemainders((class_1937)level, input.pot().method_11016(), input.getSoilItem());
                input.pot().setSoilItem(soilStack.method_7972());
            });
            this.properties.newSeed.ifPresent(seedStack -> {
                Services.GAMEPLAY.dropRemainders((class_1937)level, input.pot().method_11016(), input.getSoilItem());
                input.pot().setSeed(seedStack.method_7972());
            });
            class_1799 usedItem = input.getInteractionItem();
            if (!usedItem.method_7960()) {
                if (this.properties.damageHeld) {
                    usedItem.method_7970(1, (class_1309)player, input.hand() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                } else if (this.properties.consumeHeld) {
                    Services.GAMEPLAY.dropRemainders((class_1937)level, input.pot().method_11016(), usedItem.method_7971(1));
                }
            }
            this.properties.extraDrops.ifPresent(tableKey -> {
                class_52 table = level.method_8503().method_58576().method_58295(tableKey);
                class_2338 pos = input.pot().method_11016();
                if (table != class_52.field_948) {
                    table.method_51878(input.createLootParams(null)).forEach(drop -> class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)drop));
                }
            });
            this.properties.soundEffect.ifPresent(soundEffect -> soundEffect.playSound(level, null, input.pot().method_11016()));
            if (this.properties.notifySculk) {
                level.method_33596((class_1297)context.getPlayer(), (class_6880)class_5712.field_28733, input.pot().method_11016());
            }
        }
    }

    public boolean matches(@NotNull BotanyPotContext input, @NotNull class_1937 level) {
        return this.properties.validateInputs(input.getInteractionItem(), input.getSoilItem(), input.getSeedItem());
    }

    @NotNull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    @Override
    public boolean couldMatch(class_1799 candidate, BotanyPotContext context, class_1937 level) {
        return this.properties.validateInputs(candidate, context.getSoilItem(), context.getSeedItem());
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public boolean isCacheKey(class_1799 stack) {
        return this.properties.heldTest.method_8093(stack);
    }

    public record Properties(class_1856 heldTest, boolean damageHeld, boolean consumeHeld, Optional<class_1856> soilTest, Optional<class_1856> seedTest, Optional<class_1799> newSoil, Optional<class_1799> newSeed, Optional<class_5321<class_52>> extraDrops, Optional<SoundEffect> soundEffect, boolean notifySculk) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46095.fieldOf("held_item").forGetter(Properties::heldTest), (App)Codec.BOOL.optionalFieldOf("damage_held", (Object)true).forGetter(Properties::damageHeld), (App)Codec.BOOL.optionalFieldOf("consume_held", (Object)false).forGetter(Properties::consumeHeld), (App)class_1856.field_46095.optionalFieldOf("soil_item").forGetter(Properties::soilTest), (App)class_1856.field_46095.optionalFieldOf("seed_item").forGetter(Properties::seedTest), (App)class_1799.field_24671.optionalFieldOf("new_soil").forGetter(Properties::newSoil), (App)class_1799.field_24671.optionalFieldOf("new_seed").forGetter(Properties::newSeed), (App)class_2960.field_25139.optionalFieldOf("extra_drops").xmap(rl -> rl.map(arl -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)arl)), arl -> arl.map(class_5321::method_29177)).forGetter(Properties::extraDrops), (App)SoundEffect.CODEC.codec().optionalFieldOf("sound_effect").forGetter(Properties::soundEffect), (App)Codec.BOOL.optionalFieldOf("notify_sculk", (Object)true).forGetter(Properties::notifySculk)).apply((Applicative)instance, Properties::new));
        public static final class_9139<class_9129, Properties> STREAM = new class_9139<class_9129, Properties>(){

            @NotNull
            public Properties decode(@NotNull class_9129 buf) {
                class_1856 ingredient = (class_1856)StreamCodecs.INGREDIENT_NON_EMPTY.decode((Object)buf);
                boolean damageHeld = buf.readBoolean();
                boolean consumeHeld = buf.readBoolean();
                Optional soilTest = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                Optional seedTest = (Optional)Helpers.OPTIONAL_INGREDIENT_STREAM.decode((Object)buf);
                Optional newSoil = (Optional)Helpers.OPTIONAL_ITEMSTACK_STREAM.decode((Object)buf);
                Optional newSeed = (Optional)Helpers.OPTIONAL_ITEMSTACK_STREAM.decode((Object)buf);
                Optional<class_5321<class_52>> extraDrops = buf.method_37436((class_9141)class_2960.field_48267).map(rl -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)rl));
                Optional soundEffect = (Optional)SoundEffect.OPTIONAL_STREAM.decode((Object)buf);
                boolean notifySculk = buf.readBoolean();
                return new Properties(ingredient, damageHeld, consumeHeld, soilTest, seedTest, newSoil, newSeed, extraDrops, soundEffect, notifySculk);
            }

            public void encode(@NotNull class_9129 buf, @NotNull Properties properties) {
                StreamCodecs.INGREDIENT_NON_EMPTY.encode((Object)buf, (Object)properties.heldTest);
                buf.method_52964(properties.damageHeld);
                buf.method_52964(properties.consumeHeld);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.soilTest);
                Helpers.OPTIONAL_INGREDIENT_STREAM.encode((Object)buf, properties.seedTest);
                Helpers.OPTIONAL_ITEMSTACK_STREAM.encode((Object)buf, properties.newSoil);
                Helpers.OPTIONAL_ITEMSTACK_STREAM.encode((Object)buf, properties.newSeed);
                buf.method_37435(properties.extraDrops, (b, v) -> b.method_10812(v.method_29177()));
                SoundEffect.OPTIONAL_STREAM.encode((Object)buf, properties.soundEffect);
                buf.method_52964(properties.notifySculk);
            }
        };

        public boolean validateInputs(class_1799 held, class_1799 soil, class_1799 seed) {
            return !(!this.heldTest.method_8093(held) || !this.soilTest.isEmpty() && !this.soilTest.get().method_8093(soil) || !this.seedTest.isEmpty() && !this.seedTest.get().method_8093(seed));
        }
    }
}

