/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8567;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class EntityDrops
implements ItemDropProvider {
    public static final MapCodec<EntityDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2487.field_25128.fieldOf("entity").forGetter(EntityDrops::getEntityData), (App)class_8110.field_51565.optionalFieldOf("damage_source").forGetter(EntityDrops::getDamageType)).apply((Applicative)instance, EntityDrops::new));
    public static final class_9139<class_9129, EntityDrops> STREAM = class_9139.method_56437((buf, value) -> {
        class_9135.field_48556.encode(buf, (Object)value.entityData);
        if (value.damageType.isPresent()) {
            buf.method_52964(true);
            class_8110.field_51932.encode(buf, value.damageType.get());
        } else {
            buf.method_52964(false);
        }
        buf.method_44116((class_5321)value.lootTableId.get());
        class_1799.field_49269.encode(buf, value.getDisplayItems());
    }, buf -> {
        class_2487 entityData = (class_2487)class_9135.field_48556.decode(buf);
        boolean hasDamageType = buf.readBoolean();
        Optional<class_6880<class_8110>> damageType = hasDamageType ? Optional.of((class_6880)class_8110.field_51932.decode(buf)) : Optional.empty();
        class_5321 tableId = buf.method_44112(class_7924.field_50079);
        List displayItems = (List)class_1799.field_49269.decode(buf);
        return new EntityDrops(entityData, damageType, (class_5321<class_52>)tableId, displayItems);
    });
    private final class_2487 entityData;
    private final Optional<class_6880<class_8110>> damageType;
    private final ReloadableCache<class_1309> entity;
    private final CachedSupplier<class_5321<class_52>> lootTableId;
    private final CachedSupplier<List<class_1799>> displayItems;

    public EntityDrops(class_2487 entityData, Optional<class_6880<class_8110>> damageType) {
        this.entityData = entityData;
        this.damageType = damageType;
        this.entity = ReloadableCache.living((class_2487)entityData);
        this.lootTableId = CachedSupplier.cache(() -> {
            class_2960 entityId;
            if (entityData.method_10573("DeathLootTable", 8)) {
                return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)entityData.method_10558("DeathLootTable")));
            }
            if (entityData.method_10573("id", 8) && (entityId = class_2960.method_12829((String)entityData.method_10558("id"))) != null && class_7923.field_41177.method_10250(entityId)) {
                return ((class_1299)class_7923.field_41177.method_10223(entityId)).method_16351();
            }
            return class_39.field_844;
        });
        this.displayItems = CachedSupplier.cache(() -> {
            class_52 table = (class_52)Objects.requireNonNull((class_5455)BotanyPotsMod.REGISTRY_ACCESS.get()).method_30530(class_7924.field_50079).method_29107((class_5321)this.lootTableId.get());
            return table != null ? LootPoolEntryDescriptions.getUniqueItems((class_5455)Objects.requireNonNull((class_5455)BotanyPotsMod.REGISTRY_ACCESS.get()), (class_52)table) : List.of();
        });
    }

    public EntityDrops(class_2487 entityData, Optional<class_6880<class_8110>> damageType, class_5321<class_52> tableId, List<class_1799> displayItems) {
        this.entityData = entityData;
        this.damageType = damageType;
        this.entity = ReloadableCache.living((class_2487)entityData);
        this.lootTableId = CachedSupplier.singleton(tableId);
        this.displayItems = CachedSupplier.singleton(displayItems);
    }

    public class_2487 getEntityData() {
        return this.entityData;
    }

    public Optional<class_6880<class_8110>> getDamageType() {
        return this.damageType;
    }

    @Override
    public void apply(BotanyPotContext context, class_1937 level, Consumer<class_1799> drops) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.entity.ifPresent(level, living -> {
                class_5321 resourcekey = living.method_5989();
                class_52 loottable = serverLevel.method_8503().method_58576().method_58295(resourcekey);
                class_8567.class_8568 paramBuilder = new class_8567.class_8568(serverLevel);
                paramBuilder.method_51874(class_181.field_1226, living);
                paramBuilder.method_51874(class_181.field_24424, (Object)living.method_19538());
                paramBuilder.method_51874(class_181.field_1231, (Object)this.damageType.map(class_1282::new).orElseGet(() -> serverLevel.method_48963().method_48830()));
                loottable.method_51880(paramBuilder.method_51875(class_173.field_1173), living.method_51851(), drops);
            });
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return ItemDropProviderType.ENTITY_DROPS;
    }

    @Override
    public List<class_1799> getDisplayItems() {
        return (List)this.displayItems.get();
    }
}

