/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.IContentProvider;
import net.darkhax.bookshelf.common.api.registry.register.ItemComponentRegister;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterBlockEntityRenderer;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.darkhax.bookshelf.common.api.registry.register.RegisterRecipeType;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.api.data.display.render.DisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotScreen;
import net.darkhax.botanypots.common.impl.commands.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.BotanyPotFileGenerator;
import net.darkhax.botanypots.common.impl.data.conditions.ConfigLoadCondition;
import net.darkhax.botanypots.common.impl.data.display.renderer.EntityDisplayStateRenderer;
import net.darkhax.botanypots.common.impl.data.display.renderer.PhasedDisplayStateRenderer;
import net.darkhax.botanypots.common.impl.data.display.renderer.SimpleDisplayStateRenderer;
import net.darkhax.botanypots.common.impl.data.display.renderer.TexturedCubeStateRenderer;
import net.darkhax.botanypots.common.impl.data.display.types.AgingDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.EntityDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.TexturedCubeDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.TransitionalDisplayState;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop;
import net.darkhax.botanypots.common.impl.data.recipe.fertilizer.BasicFertilizer;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BasicSoil;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BlockDerivedSoil;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public class BotanyPotsContent
implements IContentProvider {
    public static final Supplier<class_1799> TAB_ICON = CachedSupplier.cache(() -> ((class_1792)class_7923.field_41178.method_10223(BotanyPotsMod.id("terracotta_botany_pot"))).method_7854());
    private static final String[] BRICK_TYPES = new String[]{"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<class_2960, class_2248> allPotBlocks = new LinkedHashMap<class_2960, class_2248>();

    private void make(BotanyPotFileGenerator gen, String block) {
        class_2960 blockId = class_2960.method_60656((String)block);
        gen.potRecipes(blockId);
        gen.models(blockId);
        gen.lootTables(blockId);
    }

    public void registerBlocks(Register<class_2248> registry) {
        this.createPots(registry, "terracotta");
        for (class_1767 class_17672 : class_1767.values()) {
            this.createPots(registry, class_17672.method_7792() + "_terracotta");
            this.createPots(registry, class_17672.method_7792() + "_glazed_terracotta");
            this.createPots(registry, class_17672.method_7792() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.createPots(registry, (String)("brick".equals(string) ? "bricks" : string + "_bricks"));
        }
    }

    private void createPots(Register<class_2248> registry, String name) {
        class_2960 blockId = class_2960.method_60656((String)name);
        class_3620 color = class_7923.field_41175.method_10250(blockId) ? ((class_2248)class_7923.field_41175.method_10223(blockId)).method_26403() : class_3620.field_15987;
        this.registerPot(registry, name + "_botany_pot", (class_2248)new BotanyPotBlock(color, PotType.BASIC));
        this.registerPot(registry, name + "_hopper_botany_pot", (class_2248)new BotanyPotBlock(color, PotType.HOPPER));
        this.registerPot(registry, name + "_waxed_botany_pot", (class_2248)new BotanyPotBlock(color, PotType.WAXED));
    }

    private void registerPot(Register<class_2248> registry, String id, class_2248 block) {
        class_2960 blockId = class_2960.method_60655((String)this.contentNamespace(), (String)id);
        registry.add(blockId, (Object)block);
        this.allPotBlocks.put(blockId, block);
    }

    public void registerItems(RegisterItem registry) {
        for (Map.Entry<class_2960, class_2248> block : this.allPotBlocks.entrySet()) {
            registry.addBlock(block.getValue());
        }
        DisplayType.register(SimpleDisplayState.TYPE_ID, SimpleDisplayState.CODEC, SimpleDisplayState.STREAM);
        DisplayType.register(TransitionalDisplayState.TYPE_ID, TransitionalDisplayState.CODEC, TransitionalDisplayState.STREAM);
        DisplayType.register(AgingDisplayState.TYPE_ID, AgingDisplayState.CODEC, AgingDisplayState.STREAM);
        DisplayType.register(EntityDisplayState.TYPE_ID, EntityDisplayState.CODEC, EntityDisplayState.STREAM);
        DisplayType.register(TexturedCubeDisplayState.TYPE_ID, TexturedCubeDisplayState.CODEC, TexturedCubeDisplayState.STREAM);
    }

    public void registerBlockEntities(Register<class_2591.class_2592<?>> registry) {
        registry.add("botany_pot", (Object)Services.GAMEPLAY.blockEntityBuilder(BotanyPotBlockEntity::new, (class_2248[])this.allPotBlocks.values().toArray(class_2248[]::new)));
    }

    public void registerMenus(MenuRegister registry) {
        registry.add("basic_pot_menu", BotanyPotMenu::basicMenuClient);
        registry.add("hopper_pot_menu", BotanyPotMenu::hopperMenuClient);
    }

    public void registerRecipeTypes(RegisterRecipeType registry) {
        registry.add("soil");
        registry.add("crop");
        registry.add("pot_interaction");
        registry.add("fertilizer");
    }

    public void registerRecipeSerializers(Register<class_1865<?>> registry) {
        registry.add("soil", BasicSoil.SERIALIZER);
        registry.add("block_derived_soil", BlockDerivedSoil.SERIALIZER);
        registry.add("crop", BasicCrop.SERIALIZER);
        registry.add("block_derived_crop", BlockDerivedCrop.SERIALIZER);
        registry.add("pot_interaction", BasicPotInteraction.SERIALIZER);
        registry.add("fertilizer", BasicFertilizer.SERIALIZER);
    }

    public void registerLoadConditions(Register<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    public void registerItemTabs(RegisterItemTab registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (class_2248 block : this.allPotBlocks.values()) {
                builder.method_45421((class_1935)block.method_8389());
            }
        });
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        BotanyPotsCommands.build(dispatcher, context, selection);
    }

    public void bindBlockEntityRenderer(RegisterBlockEntityRenderer registry) {
        registry.bind((class_2591)BotanyPotBlockEntity.TYPE.get(), BotanyPotRenderer::new);
        DisplayRenderer.bind((DisplayType)SimpleDisplayState.TYPE.get(), SimpleDisplayStateRenderer.RENDERER);
        DisplayRenderer.bind((DisplayType)TransitionalDisplayState.TYPE.get(), PhasedDisplayStateRenderer.TRANSITIONAL);
        DisplayRenderer.bind((DisplayType)AgingDisplayState.TYPE.get(), PhasedDisplayStateRenderer.AGING);
        DisplayRenderer.bind((DisplayType)EntityDisplayState.TYPE.get(), EntityDisplayStateRenderer.RENDERER);
        DisplayRenderer.bind((DisplayType)TexturedCubeDisplayState.TYPE.get(), TexturedCubeStateRenderer.RENDERER);
    }

    public void registerItemComponents(ItemComponentRegister registry) {
        registry.accept(CropOverride.TYPE_ID, b -> b.method_57881(CropOverride.CODEC).method_57882(CropOverride.STREAM));
        registry.accept(SoilOverride.TYPE_ID, b -> b.method_57881(SoilOverride.CODEC).method_57882(SoilOverride.STREAM));
    }

    public void registerMenuScreens(RegisterMenuScreen registry) {
        registry.bind((class_3917)BotanyPotMenu.BASIC_MENU.get(), BotanyPotScreen::new);
        registry.bind((class_3917)BotanyPotMenu.HOPPER_MENU.get(), BotanyPotScreen::new);
    }

    public void bindRenderLayers(BiConsumer<class_2248, class_1921> registry) {
        for (class_2248 block : this.allPotBlocks.values()) {
            registry.accept(block, class_1921.method_23581());
        }
    }

    public String contentNamespace() {
        return "botanypots";
    }

    public static class_2561 modMessage(class_2561 component) {
        return class_2561.method_43469((String)"commands.botanypots.mod_message", (Object[])new Object[]{component});
    }
}

