package net.darkhax.botanypots.common.impl.data.display.renderer;

import net.darkhax.botanypots.common.api.data.display.render.DisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.display.types.AgingDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.PhasedDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.TransitionalDisplayState;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public final class PhasedDisplayStateRenderer<T extends PhasedDisplayState> extends DisplayRenderer<T> {

    public static final PhasedDisplayStateRenderer<AgingDisplayState> AGING = new PhasedDisplayStateRenderer<>();
    public static final PhasedDisplayStateRenderer<TransitionalDisplayState> TRANSITIONAL = new PhasedDisplayStateRenderer<>();

    @Override
    public float render(class_5614.class_5615 renderContext, T displayState, class_4587 stack, class_1937 level, class_2338 pos, float tickDelta, class_4597 bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float growthScale, float heightOffset) {
        final int phaseIndex = Math.min(class_3532.method_15375(displayState.getDisplayPhases().size() * progress), displayState.getDisplayPhases().size() - 1);
        final Display currentState = displayState.getDisplayPhases().get(phaseIndex);
        return DisplayRenderer.renderState(renderContext, currentState, stack, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, growthScale, heightOffset);
    }
}