package net.darkhax.botanypots.common.impl;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4550;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public class Helpers {

    public static final Codec<class_2248> BLOCK_CODEC = class_2960.field_25139.xmap(class_7923.field_41175::method_10223, class_7923.field_41175::method_10221);
    public static final class_9139<ByteBuf, class_2248> BLOCK_STREAM = class_2960.field_48267.method_56432(class_7923.field_41175::method_10223, class_7923.field_41175::method_10221);
    public static final Codec<class_1792> ITEM_CODEC = class_2960.field_25139.xmap(class_7923.field_41178::method_10223, class_7923.field_41178::method_10221);
    public static final class_9139<ByteBuf, class_1792> ITEM_STREAM = class_2960.field_48267.method_56432(class_7923.field_41178::method_10223, class_7923.field_41178::method_10221);
    public static final Codec<class_1299<?>> ENTITY_TYPE_CODEC = class_2960.field_25139.xmap(class_7923.field_41177::method_10223, class_7923.field_41177::method_10221);
    public static final class_9139<ByteBuf, class_1299<?>> ENTITY_TYPE_STREAM = class_2960.field_48267.method_56432(class_7923.field_41177::method_10223, class_7923.field_41177::method_10221);
    public static final class_9139<ByteBuf, class_2680> BLOCK_STATE_STREAM = class_9135.method_56371(class_2248.field_10651);
    public static final class_9139<class_9129, Optional<class_1856>> OPTIONAL_INGREDIENT_STREAM = DataHelper.optionalStream(StreamCodecs.INGREDIENT_NON_EMPTY);
    public static final class_9139<class_9129, Optional<class_1799>> OPTIONAL_ITEMSTACK_STREAM = DataHelper.optionalStream(class_1799.field_48349);
    public static final class_9139<class_9129, Optional<class_4550>> OPTIONAL_BLOCK_PREDICATE = DataHelper.optionalStream(class_4550.field_49181);
    public static final class_9139<ByteBuf, class_6862<class_2248>> BLOCK_TAG = class_2960.field_48267.method_56432(rl -> class_6862.method_40092(class_7924.field_41254, rl), class_6862::comp_327);
    public static final class_6862<class_1887> INCREASE_POT_GROWTH_TAG = class_6862.method_40092(class_7924.field_41265, BotanyPotsMod.id("increase_pot_growth"));
    public static final class_6862<class_1887> NEGATE_HARVEST_DAMAGE_TAG = class_6862.method_40092(class_7924.field_41265, BotanyPotsMod.id("negate_harvest_damage"));

    public static class_2561 growthModifierComponent(float modifier) {
        if (modifier > 0) {
            return class_2561.method_43469("tooltip.botanypots.growth_modifier", "+" + MathsHelper.DECIMAL_2.format(modifier * 100d) + "%").method_27692(class_124.field_1078);
        }
        return class_2561.method_43469("tooltip.botanypots.growth_modifier", "-" + MathsHelper.DECIMAL_2.format(modifier * 100d) + "%").method_27692(class_124.field_1061);
    }

    public static int getRequiredGrowthTicks(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        final float cropTime = crop.getRequiredGrowthTicks(context, level);
        float growthModifier = BotanyPotsMod.CONFIG.get().gameplay.global_growth_modifier;
        growthModifier += soil != null ? soil.getGrowthModifier(context, level) : 0f;
        growthModifier += efficiencyModifier(level.method_30349(), context.getHarvestItem());
        if (context instanceof BlockEntityContext beContext) {
            growthModifier += beContext.pot().getGrowthModifier(context, level, crop, soil);
            if (beContext.pot().method_11010().method_26204() instanceof BotanyPotBlock potBlock) {
                growthModifier += potBlock.getGrowthModifier(context, level, crop, soil);
            }
        }
        return class_3532.method_15375(cropTime / growthModifier);
    }

    public static float efficiencyModifier(class_5455 registryAccess, class_1799 stack) {
        return EnchantmentLevel.HIGHEST.get(INCREASE_POT_GROWTH_TAG, stack) * BotanyPotsMod.CONFIG.get().gameplay.efficiency_growth_modifier;
    }
}