package net.darkhax.botanypots.common.impl.block.entity;

import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.TickAccumulator;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Supplier;

public class BotanyPotBlockEntity extends AbstractBotanyPotBlockEntity {

    public static final CachedSupplier<class_2591<BotanyPotBlockEntity>> TYPE = CachedSupplier.of(class_7923.field_41181, BotanyPotsMod.id("botany_pot")).cast();

    private final BlockEntityContext recipeContext = new BlockEntityContext(this, null, null);

    private final ReloadableCache<class_8786<Soil>> soil = ReloadableCache.of(level -> {
        final Optional<SoilOverride> override = SoilOverride.get(this.getSoilItem());
        if (override.isPresent()) {
            return new class_8786<>(BotanyPotsMod.BUILTIN_COMPONENT_ID, override.get().soil());
        }
        final RecipeCache<Soil> cache = Soil.CACHE.apply(level);
        return cache != null ? cache.lookup(this.getSoilItem(), recipeContext, level) : null;
    });

    private final ReloadableCache<class_8786<Crop>> crop = ReloadableCache.of(level -> {
        final Optional<CropOverride> override = CropOverride.get(this.getSeedItem());
        if (override.isPresent()) {
            return new class_8786<>(BotanyPotsMod.BUILTIN_COMPONENT_ID, override.get().crop());
        }
        final RecipeCache<Crop> cache = Crop.CACHE.apply(level);
        return cache != null ? cache.lookup(this.getSeedItem(), recipeContext, level) : null;
    });

    public TickAccumulator growthTime = new TickAccumulator(-1f);
    public int comparatorLevel = 0;
    protected TickAccumulator exportCooldown = new TickAccumulator(0f);
    protected TickAccumulator growCooldown = new TickAccumulator(0f);
    private int bonemealCooldown = 0;

    public BotanyPotBlockEntity(class_2338 pos, class_2680 state) {
        this(TYPE, pos, state);
    }

    public BotanyPotBlockEntity(Supplier<class_2591<BotanyPotBlockEntity>> type, class_2338 pos, class_2680 state) {
        super(type.get(), pos, state);
    }

    public static void tickPot(class_1937 level, class_2338 pos, class_2680 state, BotanyPotBlockEntity pot) {
        if (pot.method_11015() || pot.field_11863 == null) {
            return;
        }
        if (pot.potType.get() == PotType.WAXED) {
            pot.growthTime.setTicks(Float.MAX_VALUE);
            return;
        }
        final BlockEntityContext context = pot.recipeContext;
        if (pot.bonemealCooldown > 0) {
            pot.bonemealCooldown--;
        }
        // Update soil
        final Soil soil = pot.getOrInvalidateSoil();
        if (soil != null) {
            soil.onTick(context, level);
        }
        // Update crop
        final Crop crop = pot.getOrInvalidateCrop();
        if (crop != null) {
            crop.onTick(context, level);
            if (pot.growCooldown.getTicks() > 0) {
                pot.growCooldown.tickDown(level);
            }
            if (pot.growCooldown.getTicks() <= 0 && crop.isGrowthSustained(context, level)) {
                pot.growthTime.tickUp(level);
                crop.onGrowthTick(context, level);
                final int requiredGrowthTicks = Helpers.getRequiredGrowthTicks(pot.recipeContext, pot.field_11863, crop, soil);
                if (pot.growthTime.getTicks() >= requiredGrowthTicks) {
                    pot.updateComparatorLevel(15);
                    pot.growCooldown.setTicks(5f);
                    if (pot.isHopper() && crop.canHarvest(context, level)) {
                        if (level instanceof class_3218 serverLevel) {
                            crop.onHarvest(context, level, stack -> Services.GAMEPLAY.addItem(stack, pot.method_11282(), BotanyPotBlockEntity.STORAGE_SLOTS));
                            if (BotanyPotsMod.CONFIG.get().gameplay.damage_harvest_tool && EnchantmentLevel.FIRST.get(Helpers.NEGATE_HARVEST_DAMAGE_TAG, pot.getHarvestItem()) <= 0) {
                                pot.getHarvestItem().method_7956(1, serverLevel, null, stack -> {
                                });
                            }
                            level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(pot.method_11010()));
                        }
                        pot.growthTime.reset();
                    }
                }
                else {
                    pot.updateComparatorLevel(class_3532.method_15386(14f * (pot.growthTime.getTicks() / requiredGrowthTicks)));
                }
            }
        }
        // Update Inventory
        if (pot.isHopper()) {
            pot.exportCooldown.tickDown(level);
            if (pot.exportCooldown.getTicks() <= 0) {
                if (level instanceof class_3218 serverLevel && !serverLevel.method_8320(pot.below.get()).method_26215()) {
                    for (int slot : BotanyPotBlockEntity.STORAGE_SLOTS) {
                        final class_1799 stack = pot.method_5438(slot);
                        if (!stack.method_7960()) {
                            final class_1799 result = Services.GAMEPLAY.inventoryInsert(serverLevel, pot.below.get(), class_2350.field_11036, stack);
                            pot.method_5447(slot, result);
                        }
                    }
                }
                pot.exportCooldown.reset();
            }
        }
    }

    public boolean canHarvest() {
        final Soil soil = this.getOrInvalidateSoil();
        final Crop crop = this.getOrInvalidateCrop();
        return soil != null && crop != null && this.growthTime.getTicks() >= Helpers.getRequiredGrowthTicks(this.getRecipeContext(), this.field_11863, crop, soil) && crop.canHarvest(this.getRecipeContext(), this.field_11863);
    }

    public void reset() {
        this.growthTime.reset();
        this.updateComparatorLevel(0);
        this.crop.invalidate();
        this.soil.invalidate();
        this.bonemealCooldown = 0;
    }

    public void updateGrowthTime(float newTime) {
        this.growthTime.setTicks(newTime);
        this.markUpdated();
    }

    public void updateComparatorLevel(int newLevel) {
        if (newLevel != this.comparatorLevel && !this.method_11015() && this.field_11863 instanceof class_3218 serverLevel) {
            this.comparatorLevel = newLevel;
            serverLevel.method_8455(this.field_11867, this.method_11010().method_26204());
        }
    }

    public float growthTime() {
        return this.growthTime.getTicks();
    }

    public BlockEntityContext getRecipeContext() {
        return this.recipeContext;
    }

    public boolean canBonemeal() {
        return this.bonemealCooldown <= 0;
    }

    public void setBonemealCooldown(int cooldown) {
        this.bonemealCooldown = cooldown;
    }

    /**
     * Gets a growth modifier contributed by the block entity itself. By default, this will always be zero however
     * custom pot variants may implement other kinds of modifiers.
     *
     * @param context The context of the crop being grown.
     * @param level   The game level this is happening in.
     * @param crop    The crop being grown.
     * @param soil    The soil being used to grow the crop, may not always be available.
     * @return The growth modifier contributed by the block entity itself.
     */
    public float getGrowthModifier(BotanyPotContext context, class_1937 level, Crop crop, @Nullable Soil soil) {
        return 0f;
    }

    @Override
    public void onSoilChanged(class_1799 newStack) {
        this.reset();
        this.markUpdated();
    }

    @Override
    public void onSeedChanged(class_1799 newStack) {
        this.reset();
        this.markUpdated();
    }

    @Override
    public void onToolChanged(class_1799 newStack) {
        this.markUpdated();
    }

    public Soil getOrInvalidateSoil() {
        return this.getOrInvalidate(this.getSoilItem(), this.soil);
    }

    public Crop getOrInvalidateCrop() {
        return this.getOrInvalidate(this.getSeedItem(), this.crop);
    }

    @Nullable
    public <T extends BotanyPotRecipe> T getOrInvalidate(class_1799 stack, ReloadableCache<class_8786<T>> cache) {
        if (this.field_11863 == null || stack.method_7960()) {
            cache.invalidate();
            return null;
        }
        final class_8786<T> value = cache.apply(field_11863);
        if (value != null) {
            final T innerValue = value.comp_1933();
            if (!innerValue.method_8115(this.recipeContext, this.field_11863)) {
                cache.invalidate();
                return null;
            }
            return innerValue;
        }
        return null;
    }

    @Override
    public void method_11014(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.growthTime.setTicks(tag.method_10583("growth_time"));
        this.comparatorLevel = tag.method_10550("comparator_level");
        this.exportCooldown = new TickAccumulator(tag.method_10583("export_delay"));
        this.growCooldown = new TickAccumulator(tag.method_10583("grow_cooldown"));
        this.bonemealCooldown = tag.method_10550("bonemeal_cooldown");
    }

    @Override
    public void method_11007(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10548("growth_time", this.growthTime.getTicks());
        tag.method_10569("comparator_level", this.comparatorLevel);
        tag.method_10548("export_delay", this.exportCooldown.getTicks());
        tag.method_10548("grow_cooldown", this.growCooldown.getTicks());
        tag.method_10569("bonemeal_cooldown", this.bonemealCooldown);
    }

    @NotNull
    @Override
    public class_2487 method_16887(@NotNull class_7225.class_7874 registries) {
        final class_2487 syncTag = this.method_58692(registries);
        syncTag.method_10551("comparator_level");
        syncTag.method_10566("Items", DataHelper.containerSubList(syncTag.method_10554("Items", class_2520.field_33260), slot -> slot <= TOOL_SLOT));
        return syncTag;
    }

    @Override
    public class_2622 method_38235() {
        return class_2622.method_38585(this);
    }

    @NotNull
    @Override
    protected class_1703 method_5465(int containerId, @NotNull class_1661 playerInv) {
        return BotanyPotMenu.potMenuServer(containerId, playerInv, this);
    }

    public int getRequiredGrowthTicks() {
        final class_8786<Crop> crop = this.crop.apply(this.field_11863);
        return crop == null ? -1 : Helpers.getRequiredGrowthTicks(this.recipeContext, this.field_11863, crop.comp_1933(), this.soil.map(this.field_11863, class_8786::comp_1933));
    }
}