/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.BotanyPotsPlugin;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.crop.CropGenerator;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.command.generator.MissingCropGenerator;
import net.darkhax.botanypots.common.impl.command.generator.MissingSoilGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2473;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.io.FileUtils;

public class MissingCommand {
    private static final CachedSupplier<Map<class_2960, SoilGenerator>> SOIL_GENERATORS = CachedSupplier.cache(() -> {
        LinkedHashMap<class_2960, MissingSoilGenerator> generators = new LinkedHashMap<class_2960, MissingSoilGenerator>();
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(plugin -> plugin.registerSoilGenerators(generators::put));
        generators.put(BotanyPotsMod.id("missing_fallback"), new MissingSoilGenerator());
        return generators;
    });
    private static final CachedSupplier<Map<class_2960, CropGenerator>> CROP_GENERATORS = CachedSupplier.cache(() -> {
        LinkedHashMap<class_2960, MissingCropGenerator> generators = new LinkedHashMap<class_2960, MissingCropGenerator>();
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(plugin -> plugin.registerCropGenerators(generators::put));
        generators.put(BotanyPotsMod.id("missing_fallback"), new MissingCropGenerator());
        return generators;
    });
    private static final class_6862<class_1792> SAPLING_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60656((String)"saplings"));
    private static final Comparator<class_2960> ID_COMPARE = Comparator.comparing(class_2960::toString);

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        LiteralArgumentBuilder cmd = class_2170.method_9247((String)"missing");
        LiteralArgumentBuilder seeds = class_2170.method_9247((String)"seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"include_saplings", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)).then(class_2170.method_9244((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then((ArgumentBuilder)seeds);
        LiteralArgumentBuilder soils = class_2170.method_9247((String)"soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(class_2170.method_9244((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then((ArgumentBuilder)soils);
        parent.then((ArgumentBuilder)cmd);
    }

    private static Map<class_1799, SoilGenerator> collectMissingSoilItems(class_3218 level) {
        HashMap<class_1799, SoilGenerator> missing = new HashMap<class_1799, SoilGenerator>();
        block0: for (class_1792 item : class_7923.field_41178) {
            class_1799 stack = item.method_7854();
            if (MissingCommand.isSoil(stack, (class_1937)level) || MissingCommand.isCrop(stack, (class_1937)level)) continue;
            for (SoilGenerator generator : ((Map)SOIL_GENERATORS.get()).values()) {
                if (!generator.canGenerateSoil(level, stack)) continue;
                missing.put(stack, generator);
                continue block0;
            }
        }
        return missing;
    }

    private static int dumpMissingSoils(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Map<class_1799, SoilGenerator> missing = MissingCommand.collectMissingSoilItems(level);
        if (missing.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outDir = MissingCommand.setupDir("botanypots/generated/soils");
            for (Map.Entry<class_1799, SoilGenerator> entry2 : missing.entrySet()) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)entry2.getKey().method_7909());
                File soilFile = new File(outDir, itemId.method_12836() + "/soil/" + itemId.method_12832() + ".json");
                JsonObject obj = entry2.getValue().generateData(level, entry2.getKey());
                MissingCommand.writeFile(soilFile, DataHelper.GSON.toJson((JsonElement)obj));
            }
        }
        StringJoiner entries = new StringJoiner(System.lineSeparator());
        entries.add("Potential missing soil IDs");
        missing.keySet().stream().map(stack -> class_7923.field_41178.method_10221((Object)stack.method_7909())).sorted(Comparator.comparing(class_2960::toString)).forEach(entry -> entries.add(entry.toString()));
        ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_soils", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missing.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        return missing.size();
    }

    private static Map<class_1799, CropGenerator> collectMissingCropItems(boolean collectSaplings, class_3218 level) {
        HashMap<class_1799, CropGenerator> missing = new HashMap<class_1799, CropGenerator>();
        block0: for (class_1792 item : class_7923.field_41178) {
            class_1799 stack = item.method_7854();
            if (MissingCommand.isSoil(stack, (class_1937)level) || MissingCommand.isCrop(stack, (class_1937)level) || !collectSaplings && MissingCommand.isSapling(item)) continue;
            for (CropGenerator generator : ((Map)CROP_GENERATORS.get()).values()) {
                if (!generator.canGenerateCrop(level, stack)) continue;
                missing.put(stack, generator);
                continue block0;
            }
        }
        return missing;
    }

    private static int dumpMissingCrops(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        boolean includeSaplings = CommandHelper.getBooleanArg((String)"include_saplings", ctx, () -> false);
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Map<class_1799, CropGenerator> missingCrops = MissingCommand.collectMissingCropItems(includeSaplings, level);
        if (missingCrops.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outdir = MissingCommand.setupDir("botanypots/generated/crops");
            for (Map.Entry<class_1799, CropGenerator> entry : missingCrops.entrySet()) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.getKey().method_7909());
                File cropFile = new File(outdir, itemId.method_12836() + "/crop/" + itemId.method_12832() + ".json");
                MissingCommand.writeFile(cropFile, DataHelper.GSON.toJson((JsonElement)entry.getValue().generateData(level, entry.getKey())));
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.botanypots.dump.generated").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, outdir.getAbsolutePath()))), false);
        } else {
            StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach((k, v) -> entries.add(class_7923.field_41178.method_10221((Object)k.method_7909()).toString()));
            ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missingCrops.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
        }
        return missingCrops.size();
    }

    private static void processTag(class_6862<class_1792> key, Consumer<class_1792> consumer) {
        class_7923.field_41178.method_40266(key).ifPresent(named -> named.forEach(entry -> consumer.accept((class_1792)entry.comp_349())));
    }

    private static boolean isCrop(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(class_1799 stack, class_1937 level) {
        return Objects.requireNonNull((RecipeCache)Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(class_1792 item) {
        class_1747 blockItem;
        return item.method_7854().method_31573(SAPLING_TAG) || item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof class_2473;
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File setupDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", (Object)dir, (Object)e);
            }
        }
        file.mkdirs();
        return file;
    }
}

