package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.List;
import java.util.function.Supplier;

public class BlockStateDrops extends BlockDrops {

    public static final Supplier<ItemDropProviderType<?>> TYPE = ItemDropProviderType.getLazy(BotanyPotsMod.id("block_state"));
    public static final MapCodec<BlockStateDrops> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            MapCodecs.BLOCK_STATE_MAP_CODEC.fieldOf("block_state").forGetter(BlockStateDrops::getHarvestState)
    ).apply(instance, BlockStateDrops::new));

    public static final class_9139<class_9129, BlockStateDrops> STREAM = class_9139.method_56437(
            (buf, val) -> {
                Helpers.BLOCK_STATE_STREAM.encode(buf, val.getHarvestState());
                buf.method_10812(val.getTableId());
                class_1799.field_49269.encode(buf, val.getDisplayItems());
            },
            buf -> {
                final class_2680 state = Helpers.BLOCK_STATE_STREAM.decode(buf);
                final class_2960 tableId = buf.method_10810();
                final List<class_1799> items = class_1799.field_49269.decode(buf);
                return new BlockStateDrops(state, tableId, items);
            }
    );

    // server
    public BlockStateDrops(class_2680 state) {
        super(state.method_26204(), state);
    }

    // client
    public BlockStateDrops(class_2680 state, class_2960 tableId, List<class_1799> displayItems) {
        super(state.method_26204(), state, tableId, displayItems);
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return TYPE.get();
    }
}