/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.render;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public abstract class DisplayRenderer<T extends Display> {
    private static final Map<DisplayType<?>, DisplayRenderer<?>> RENDERERS = new HashMap();

    public static DisplayRenderer<?> getRenderer(Display state) {
        DisplayRenderer<?> renderer = RENDERERS.get(state.getType());
        if (renderer == null) {
            throw new IllegalStateException("Display state " + String.valueOf(state.getType().typeId()) + " is not bound to a renderer.");
        }
        return renderer;
    }

    public static float renderState(class_5614.class_5615 context, Display displayState, class_4587 stack, class_1937 level, class_2338 pos, float tickDelta, class_4597 bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float growthScale, float heightOffset) {
        return DisplayRenderer.getRenderer(displayState).render(context, displayState, stack, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, growthScale, heightOffset);
    }

    public abstract float render(class_5614.class_5615 var1, T var2, class_4587 var3, class_1937 var4, class_2338 var5, float var6, class_4597 var7, int var8, int var9, BotanyPotBlockEntity var10, float var11, float var12, float var13);

    public static <T extends Display> void bind(DisplayType<T> type, DisplayRenderer<T> renderer) {
        if (RENDERERS.containsKey(type)) {
            BotanyPotsMod.LOG.warn("Renderer already bound for type " + String.valueOf(type.typeId()) + ". Replacing " + RENDERERS.get(type).toString() + " with " + renderer.toString());
        }
        RENDERERS.put(type, renderer);
    }
}

