package net.darkhax.botanypots.common.impl.block;

import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.block.IBlockHooks;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_8786;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.ToIntFunction;

public class BotanyPotBlock extends class_2237 implements class_3737, IBlockHooks {

    public static final class_265 SHAPE = class_2248.method_9541(2, 0, 2, 14, 8, 14);
    public static final ToIntFunction<class_2680> LIGHT_LEVEL = state -> state.method_11654(class_2741.field_12538);

    public final PotType type;

    public BotanyPotBlock(class_3620 color, PotType type) {
        this(class_4970.class_2251.method_9637().method_31710(color).method_9629(1.25f, 4.2f).method_22488().method_9631(LIGHT_LEVEL), type);
    }

    public BotanyPotBlock(class_2251 properties, PotType type) {
        super(properties);
        this.method_9590(this.method_9595().method_11664()
                .method_11657(class_2741.field_12508, false)
                .method_11657(class_2741.field_12538, 0)
                .method_11657(class_2741.field_12481, class_2350.field_11043)
        );
        this.type = type;
    }

    public boolean isHopper() {
        return this.type == PotType.HOPPER;
    }

    @NotNull
    @Override
    protected class_9062 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hitResult) {
        if (this.type != PotType.WAXED && level.method_8321(pos) instanceof BotanyPotBlockEntity pot) {
            final BlockEntityContext context = new BlockEntityContext(pot, player, hand);

            // Harvest basic pots
            if (this.type == PotType.BASIC && pot.canHarvest()) {
                pot.growthTime.reset();
                if (level instanceof class_3218 serverLevel) {
                    pot.getOrInvalidateCrop().onHarvest(pot.getRecipeContext(), level, dropOutput -> class_2248.method_9577(level, pos, dropOutput));
                    level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(pot.method_11010()));
                }
                return class_9062.method_55644(level.field_9236);
            }

            // Fertilizer
            final class_8786<Fertilizer> fertilizer = Fertilizer.getFertilizer(level, context, player.method_5998(hand));
            if (fertilizer != null && fertilizer.comp_1933().method_8115(context, level)) {
                fertilizer.comp_1933().apply(context, level);
                return class_9062.method_55644(level.field_9236);
            }

            // Pot Interaction
            final class_8786<PotInteraction> interaction = PotInteraction.getInteraction(level, context, player.method_5998(hand));
            if (interaction != null && interaction.comp_1933().method_8115(context, level)) {
                interaction.comp_1933().apply(context);
                return class_9062.method_55644(level.field_9236);
            }
        }
        // Menu
        if (level.field_9236) {
            return class_9062.field_47728;
        }
        else {
            openMenu(state, level, pos, player);
            return class_9062.field_47729;
        }
    }

    public void openMenu(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        class_3908 menuprovider = this.method_17454(state, level, pos);
        if (menuprovider != null) {
            player.method_17355(menuprovider);
        }
    }

    @Nullable
    protected class_3908 method_17454(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos) {
        if (level.method_8321(pos) instanceof BotanyPotBlockEntity pot) {
            return pot;
        }
        return super.method_17454(state, level, pos);
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return method_31618(type, BotanyPotBlockEntity.TYPE.get(), BotanyPotBlockEntity::tickPot);
    }

    @NotNull
    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        throw new RuntimeException("Codecs for this block have not been implemented yet. Sorry :(");
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        final class_2338 placedPos = context.method_8037();
        final class_3610 fluidState = context.method_8045().method_8316(placedPos);
        class_2680 placedState = super.method_9564().method_11657(class_2741.field_12508, fluidState.method_15772() == class_3612.field_15910);
        if (context.method_7715().method_10166().method_10179()) {
            placedState = placedState.method_11657(class_2741.field_12481, context.method_7715().method_10153());
        }
        return placedState;
    }

    @Override
    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        class_1264.method_54291(state, newState, level, pos);
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @NotNull
    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean method_9579(class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return state.method_26227().method_15769();
    }

    @Override
    public boolean method_9498(@NotNull class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(@NotNull class_2680 state, class_1937 world, @NotNull class_2338 pos) {
        return world.method_8321(pos) instanceof BotanyPotBlockEntity pot ? pot.comparatorLevel : 0;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12508, class_2741.field_12538, class_2741.field_12481);
    }

    @NotNull
    @Override
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return SHAPE;
    }

    @NotNull
    @Override
    public class_2464 method_9604(@NotNull class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new BotanyPotBlockEntity(BotanyPotBlockEntity.TYPE, pos, state);
    }
}