package net.darkhax.botanypots.common.api.context;

import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Recipe context that is provided when an actual botany pot is available.
 *
 * @param pot    The botany pot that is available.
 * @param player An optional player that is relevant to the current context.
 * @param hand   The hand being used by the player, if one was used.
 */
public record BlockEntityContext(BotanyPotBlockEntity pot, @Nullable class_1657 player, @Nullable class_1268 hand) implements BotanyPotContext {

    @NotNull
    @Override
    public class_1799 method_59984(int slotId) {
        return pot.method_5438(slotId);
    }

    @Override
    public int method_59983() {
        return pot.method_5439();
    }

    @Override
    public class_1799 getSoilItem() {
        return pot.getSoilItem();
    }

    @Override
    public class_1799 getSeedItem() {
        return pot.getSeedItem();
    }

    @Override
    public class_1799 getHarvestItem() {
        return pot.getHarvestItem();
    }

    @Override
    public class_8567 createLootParams(@Nullable class_2680 state) {
        if (this.pot.method_10997() instanceof class_3218 level) {
            final class_8567.class_8568 paramBuilder = new class_8567.class_8568(level);
            paramBuilder.method_51874(class_181.field_1224, state != null ? state : level.method_8320(this.pot.method_11016()));
            paramBuilder.method_51874(class_181.field_24424, class_243.method_24953(this.pot.method_11016()));
            paramBuilder.method_51874(class_181.field_1229, this.getInteractionItem());
            paramBuilder.method_51877(class_181.field_1226, this.player);
            paramBuilder.method_51877(class_181.field_1228, this.pot);
            paramBuilder.method_51877(class_181.field_1229, this.pot.getHarvestItem().method_7960() ? BotanyPotsMod.CONFIG.get().gameplay.default_harvest_tool.apply(level) : this.pot.getHarvestItem());
            return paramBuilder.method_51875(class_173.field_1172);
        }
        throw new IllegalStateException("Can not create LootParams on the client!");
    }

    @Override
    public void runFunction(class_2960 functionId) {
        this.pot.runFunction(functionId);
    }

    @Override
    public @Nullable class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public class_1799 getInteractionItem() {
        return (this.player != null && this.hand != null) ? this.player.method_5998(this.hand) : class_1799.field_8037;
    }

    @Override
    public int getRequiredGrowthTicks() {
        return this.pot.getRequiredGrowthTicks();
    }

    @Override
    public boolean isServerThread() {
        class_1937 level = this.pot.method_10997();
        if (level == null && this.player != null) {
            level = this.player.method_37908();
        }
        return level != null && !level.field_9236;
    }
}