package net.darkhax.botanypots.common.impl.data.display.renderer;

import net.darkhax.botanypots.common.api.data.display.render.DisplayRenderer;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.display.types.EntityDisplayState;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.joml.Vector3f;

public final class EntityDisplayStateRenderer extends DisplayRenderer<EntityDisplayState> {

    public static final EntityDisplayStateRenderer RENDERER = new EntityDisplayStateRenderer();

    @Override
    public float render(class_5614.class_5615 context, EntityDisplayState displayState, class_4587 pose, class_1937 level, class_2338 pos, float tickDelta, class_4597 bufferSource, int light, int overlay, BotanyPotBlockEntity pot, float progress, float cropScale, float heightOffset) {
        final class_1297 displayEntity = displayState.getDisplayEntity().apply(level);
        if (displayEntity != null) {
            if (displayState.shouldTickEntity()) {
                displayEntity.field_6012 = (int) (level.method_8510() % Integer.MAX_VALUE);
            }
            pose.method_22903();
            pose.method_22904(0.5, 0, 0.5);
            final Vector3f scale = displayState.getScale();
            pose.method_22905(scale.x(), scale.y(), scale.z());
            displayState.getOffset().ifPresent(offset -> pose.method_46416(offset.x(), offset.y(), offset.z()));
            if (displayState.getSpinSpeed() > 0) {
                pose.method_22907(class_7833.field_40716.rotationDegrees((360f * displayState.getSpinSpeed()) * progress));
            }
            renderEntityAndPassengers(context.method_43334(), displayEntity, tickDelta, pose, bufferSource, light);
            pose.method_22909();
        }
        return 0f;
    }

    private static void renderEntityAndPassengers(class_898 renderer, class_1297 parent, float tickDelta, class_4587 pose, class_4597 buffer, int light) {
        renderer.method_3954(parent, 0, 0, 0, 0, tickDelta, pose, buffer, light);
        for (class_1297 passenger : parent.method_5685()) {
            final class_243 passengerPosition = parent.method_52538(passenger);
            pose.method_22904(passengerPosition.field_1352, passengerPosition.field_1351, passengerPosition.field_1350);
            renderEntityAndPassengers(renderer, passenger, tickDelta, pose, buffer, light);
        }
    }
}