package net.darkhax.botanypots.common.impl.command.generator;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.crop.CropGenerator;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2230;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2420;
import net.minecraft.class_2473;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4863;
import net.minecraft.class_5809;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

/**
 * This crop generator is used as a fallback when none of the other generators have claimed an item. It will generate a
 * block derived crop for a wide range of blocks in the game such as flowers, seeds, crop blocks, bonemealable blocks,
 * and corals.
 */
public class MissingCropGenerator implements CropGenerator {

    private static final class_6862<class_1792> FLOWERS = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("minecraft", "flowers"));
    private static final class_6862<class_1792> FORGE_SEEDS = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("forge", "seeds"));
    private static final class_6862<class_1792> COMMON_SEEDS = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "seeds"));
    private static final class_6862<class_1792> IGNORED_ITEMS = class_6862.method_40092(class_7924.field_41197, BotanyPotsMod.id("crop_generator_ignores"));

    @Override
    public boolean canGenerateCrop(class_3218 level, class_1799 stack) {
        if (stack.method_31573(IGNORED_ITEMS)) {
            return false;
        }
        if (stack.method_7909() instanceof class_1747 blockItem) {
            if (stack.method_31573(FORGE_SEEDS) || stack.method_31573(COMMON_SEEDS) || stack.method_31573(FLOWERS)) {
                return true;
            }
            final class_2248 placedBlock = blockItem.method_7711();
            final class_2960 blockId = class_7923.field_41175.method_10221(placedBlock);
            if (placedBlock instanceof class_2302 || placedBlock instanceof class_4863 || placedBlock instanceof class_2256 || placedBlock instanceof class_2473 || placedBlock instanceof class_2261 || placedBlock instanceof class_5809 || (placedBlock instanceof class_2230 && !blockId.method_12832().startsWith("dead_"))) {
                return true;
            }

        }
        return false;
    }

    @Override
    public JsonObject generateData(class_3218 level, class_1799 stack) {
        final JsonObject output = new JsonObject();
        final class_2248 block = ((class_1747) stack.method_7909()).method_7711();
        output.add("bookshelf:load_conditions", DataHelper.array(DataHelper.requiresBlock(block)));
        output.addProperty("type", "botanypots:block_derived_crop");
        output.addProperty("block", class_7923.field_41175.method_10221(block).toString());
        if (block instanceof class_2230) {
            output.add("soil", DataHelper.tag(BotanyPotsMod.id("soil/water")));
        }
        if (block instanceof class_2420) {
            final JsonObject blockTag = DataHelper.blockTag(class_2960.method_60656("mushroom_grow_block"));
            final JsonObject itemTag = DataHelper.tag(BotanyPotsMod.id("soil/mushroom"));
            output.add("soil", DataHelper.ingredients(blockTag, itemTag));
        }
        output.add("input", DataHelper.ingredient(class_1856.method_8101(stack)));
        return output;
    }
}
