package net.darkhax.botanypots.common.api.data.components;

import com.mojang.serialization.Codec;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import java.util.Optional;

/**
 * This item component allows specific items to define a crop that differs from their default recipe-based behavior. For
 * example, a specific dirt item with this override could grow diamonds while all other instances are not valid seeds
 * and have no crop.
 *
 * @param crop The crop to use instead of the default recipe-based lookup.
 */
public record CropOverride(Crop crop) {

    public static final Codec<CropOverride> CODEC = BotanyPotRecipe.recipeCodec(Crop.TYPE).xmap(CropOverride::new, CropOverride::crop);
    public static final class_9139<class_9129, CropOverride> STREAM = BotanyPotRecipe.recipeStream(Crop.TYPE).method_56432(CropOverride::new, CropOverride::crop);
    public static final class_2960 TYPE_ID = BotanyPotsMod.id("crop");
    public static final CachedSupplier<class_9331<CropOverride>> TYPE = CachedSupplier.of(class_7923.field_49658, TYPE_ID).cast();

    /**
     * Gets the override value for an item if one exists.
     *
     * @param stack The stack to query.
     * @return The current crop override as an optional. If an override is specified the optional will be present,
     * otherwise it will be empty.
     */
    public static Optional<CropOverride> get(class_1799 stack) {
        return stack.method_57826(TYPE.get()) ? Optional.ofNullable(stack.method_57824(TYPE.get())) : Optional.empty();
    }

    /**
     * Applies a crop override to the specified item.
     *
     * @param stack The item to apply the override to.
     * @param crop  The crop to attach as an override.
     */
    public static void set(class_1799 stack, Crop crop) {
        stack.method_57379(TYPE.get(), new CropOverride(crop));
    }
}