/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block.entity;

import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.TickAccumulator;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.api.data.recipes.BotanyPotRecipe;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.AbstractBotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.config.Config;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotBlockEntity
extends AbstractBotanyPotBlockEntity {
    public static final CachedSupplier<class_2591<BotanyPotBlockEntity>> TYPE = CachedSupplier.of((class_2378)class_7923.field_41181, (class_2960)BotanyPotsMod.id("botany_pot")).cast();
    private final BlockEntityContext recipeContext = new BlockEntityContext(this, null, null);
    private final ReloadableCache<class_8786<Soil>> soil = ReloadableCache.of(level -> {
        Optional<SoilOverride> override = SoilOverride.get(this.getSoilItem());
        if (override.isPresent()) {
            return new class_8786(BotanyPotsMod.BUILTIN_COMPONENT_ID, (class_1860)override.get().soil());
        }
        RecipeCache cache = (RecipeCache)Soil.CACHE.apply(level);
        return cache != null ? cache.lookup(this.getSoilItem(), this.recipeContext, (class_1937)level) : null;
    });
    private final ReloadableCache<class_8786<Crop>> crop = ReloadableCache.of(level -> {
        Optional<CropOverride> override = CropOverride.get(this.getSeedItem());
        if (override.isPresent()) {
            return new class_8786(BotanyPotsMod.BUILTIN_COMPONENT_ID, (class_1860)override.get().crop());
        }
        RecipeCache cache = (RecipeCache)Crop.CACHE.apply(level);
        return cache != null ? cache.lookup(this.getSeedItem(), this.recipeContext, (class_1937)level) : null;
    });
    public TickAccumulator growthTime = new TickAccumulator(-1.0f);
    public int comparatorLevel = 0;
    protected TickAccumulator exportCooldown = new TickAccumulator(0.0f);
    protected TickAccumulator growCooldown = new TickAccumulator(0.0f);
    private int bonemealCooldown = 0;

    public BotanyPotBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)TYPE.get(), pos, state);
    }

    public static void tickPot(class_1937 level, class_2338 pos, class_2680 state, BotanyPotBlockEntity pot) {
        Crop crop;
        Soil soil;
        if (pot.method_11015() || pot.field_11863 == null) {
            return;
        }
        if (pot.potType.get() == PotType.WAXED) {
            pot.growthTime.setTicks(Float.MAX_VALUE);
            return;
        }
        BlockEntityContext context = pot.recipeContext;
        if (pot.bonemealCooldown > 0) {
            --pot.bonemealCooldown;
        }
        if ((soil = pot.getOrInvalidateSoil()) != null) {
            soil.onTick(context, level);
        }
        if ((crop = pot.getOrInvalidateCrop()) != null) {
            crop.onTick(context, level);
            if (pot.growCooldown.getTicks() > 0.0f) {
                pot.growCooldown.tickDown(level);
            }
            if (pot.growCooldown.getTicks() <= 0.0f && crop.isGrowthSustained(context, level)) {
                pot.growthTime.tickUp(level);
                crop.onGrowthTick(context, level);
                int requiredGrowthTicks = Helpers.getRequiredGrowthTicks(pot.recipeContext, pot.field_11863, crop, soil);
                if (pot.growthTime.getTicks() >= (float)requiredGrowthTicks) {
                    pot.updateComparatorLevel(15);
                    pot.growCooldown.setTicks(5.0f);
                    if (pot.isHopper() && crop.canHarvest(context, level)) {
                        if (level instanceof class_3218) {
                            class_3218 serverLevel = (class_3218)level;
                            crop.onHarvest(context, level, stack -> Services.GAMEPLAY.addItem(stack, pot.method_11282(), STORAGE_SLOTS));
                            if (((Config)BotanyPotsMod.CONFIG.get()).gameplay.damage_harvest_tool && EnchantmentLevel.FIRST.get(Helpers.NEGATE_HARVEST_DAMAGE_TAG, pot.getHarvestItem()) <= 0) {
                                pot.getHarvestItem().method_7956(1, serverLevel, null, stack -> {});
                            }
                            level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)pot.method_11010()));
                        }
                        pot.growthTime.reset();
                    }
                } else {
                    pot.updateComparatorLevel(class_3532.method_15386((float)(14.0f * (pot.growthTime.getTicks() / (float)requiredGrowthTicks))));
                }
            }
        }
        if (pot.isHopper()) {
            pot.exportCooldown.tickDown(level);
            if (pot.exportCooldown.getTicks() <= 0.0f) {
                class_3218 serverLevel;
                if (level instanceof class_3218 && !(serverLevel = (class_3218)level).method_8320((class_2338)pot.below.get()).method_26215()) {
                    for (int slot : STORAGE_SLOTS) {
                        class_1799 stack2 = pot.method_5438(slot);
                        if (stack2.method_7960()) continue;
                        class_1799 result = Services.GAMEPLAY.inventoryInsert(serverLevel, (class_2338)pot.below.get(), class_2350.field_11036, stack2);
                        pot.method_5447(slot, result);
                    }
                }
                pot.exportCooldown.reset();
            }
        }
    }

    public boolean canHarvest() {
        Soil soil = this.getOrInvalidateSoil();
        Crop crop = this.getOrInvalidateCrop();
        return soil != null && crop != null && this.growthTime.getTicks() >= (float)Helpers.getRequiredGrowthTicks(this.getRecipeContext(), this.field_11863, crop, soil) && crop.canHarvest(this.getRecipeContext(), this.field_11863);
    }

    public void reset() {
        this.growthTime.reset();
        this.updateComparatorLevel(0);
        this.crop.invalidate();
        this.soil.invalidate();
        this.bonemealCooldown = 0;
    }

    public void updateGrowthTime(float newTime) {
        this.growthTime.setTicks(newTime);
        this.markUpdated();
    }

    public void updateComparatorLevel(int newLevel) {
        class_1937 class_19372;
        if (newLevel != this.comparatorLevel && !this.method_11015() && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.comparatorLevel = newLevel;
            serverLevel.method_8455(this.field_11867, this.method_11010().method_26204());
        }
    }

    public float growthTime() {
        return this.growthTime.getTicks();
    }

    public BlockEntityContext getRecipeContext() {
        return this.recipeContext;
    }

    public boolean canBonemeal() {
        return this.bonemealCooldown <= 0;
    }

    public void setBonemealCooldown(int cooldown) {
        this.bonemealCooldown = cooldown;
    }

    @Override
    public void onSoilChanged(class_1799 newStack) {
        this.reset();
        this.markUpdated();
    }

    @Override
    public void onSeedChanged(class_1799 newStack) {
        this.reset();
        this.markUpdated();
    }

    @Override
    public void onToolChanged(class_1799 newStack) {
        this.markUpdated();
    }

    public Soil getOrInvalidateSoil() {
        return this.getOrInvalidate(this.getSoilItem(), this.soil);
    }

    public Crop getOrInvalidateCrop() {
        return this.getOrInvalidate(this.getSeedItem(), this.crop);
    }

    @Nullable
    public <T extends BotanyPotRecipe> T getOrInvalidate(class_1799 stack, ReloadableCache<class_8786<T>> cache) {
        if (this.field_11863 == null || stack.method_7960()) {
            cache.invalidate();
            return null;
        }
        class_8786 value = (class_8786)cache.apply(this.field_11863);
        if (value != null) {
            BotanyPotRecipe innerValue = (BotanyPotRecipe)value.comp_1933();
            if (!innerValue.method_8115(this.recipeContext, this.field_11863)) {
                cache.invalidate();
                return null;
            }
            return (T)innerValue;
        }
        return null;
    }

    @Override
    public void method_11014(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.growthTime.setTicks(tag.method_10583("growth_time"));
        this.comparatorLevel = tag.method_10550("comparator_level");
        this.exportCooldown = new TickAccumulator(tag.method_10583("export_delay"));
        this.growCooldown = new TickAccumulator(tag.method_10583("grow_cooldown"));
        this.bonemealCooldown = tag.method_10550("bonemeal_cooldown");
    }

    @Override
    public void method_11007(@NotNull class_2487 tag, @NotNull class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10548("growth_time", this.growthTime.getTicks());
        tag.method_10569("comparator_level", this.comparatorLevel);
        tag.method_10548("export_delay", this.exportCooldown.getTicks());
        tag.method_10548("grow_cooldown", this.growCooldown.getTicks());
        tag.method_10569("bonemeal_cooldown", this.bonemealCooldown);
    }

    @NotNull
    public class_2487 method_16887(@NotNull class_7225.class_7874 registries) {
        class_2487 syncTag = this.method_58692(registries);
        syncTag.method_10551("comparator_level");
        syncTag.method_10566("Items", (class_2520)DataHelper.containerSubList((class_2499)syncTag.method_10554("Items", 10), slot -> slot <= 2));
        return syncTag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    protected class_1703 method_5465(int containerId, @NotNull class_1661 playerInv) {
        return BotanyPotMenu.potMenuServer(containerId, playerInv, this);
    }

    public int getRequiredGrowthTicks() {
        class_8786 crop = (class_8786)this.crop.apply(this.field_11863);
        return crop == null ? -1 : Helpers.getRequiredGrowthTicks(this.recipeContext, this.field_11863, (Crop)crop.comp_1933(), (Soil)this.soil.map(this.field_11863, class_8786::comp_1933));
    }
}

