/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.display.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.PhasedDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9139;

public class AgingDisplayState
extends PhasedDisplayState {
    public static final class_2960 TYPE_ID = BotanyPotsMod.id("aging");
    public static final CachedSupplier<DisplayType<AgingDisplayState>> TYPE = CachedSupplier.cache(() -> DisplayType.get(TYPE_ID));
    public static final MapCodec<AgingDisplayState> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Helpers.BLOCK_CODEC.fieldOf("block").forGetter(AgingDisplayState::getBlock), (App)BasicOptions.CODEC.optionalFieldOf("options", (Object)BasicOptions.ofDefault()).forGetter(AgingDisplayState::getRenderOptions)).apply((Applicative)instance, AgingDisplayState::new));
    public static final class_9139<class_2540, AgingDisplayState> STREAM = class_9139.method_56435(Helpers.BLOCK_STREAM, AgingDisplayState::getBlock, BasicOptions.STREAM, AgingDisplayState::getRenderOptions, AgingDisplayState::new);
    private final class_2248 block;
    private final BasicOptions renderOptions;
    private final List<Display> phases;

    public AgingDisplayState(class_2248 block, BasicOptions renderOptions) {
        this.block = block;
        this.renderOptions = renderOptions;
        this.phases = this.calculatePhases(block);
    }

    private List<Display> calculatePhases(class_2248 block) {
        ArrayList<Display> phases = new ArrayList<Display>();
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            for (int cropStage = 0; cropStage < crop.method_9827(); ++cropStage) {
                try {
                    class_2680 agedState = crop.method_9828(cropStage);
                    phases.add(new SimpleDisplayState(agedState, this.renderOptions));
                    continue;
                }
                catch (Exception e) {
                    BotanyPotsMod.LOG.error("Invalid crop age found! id={} block={} age={}", new Object[]{class_7923.field_41175.method_10221((Object)block), block, cropStage});
                    BotanyPotsMod.LOG.error("Error: ", (Throwable)e);
                }
            }
        } else if (block.method_9564().method_28498((class_2769)class_2741.field_42835)) {
            class_2769 flowerCount = block.method_9595().method_11663("flower_amount");
            if (flowerCount instanceof class_2758) {
                class_2758 property = (class_2758)flowerCount;
                Iterator iterator = property.method_11898().iterator();
                while (iterator.hasNext()) {
                    int amount = (Integer)iterator.next();
                    phases.add(new SimpleDisplayState((class_2680)block.method_9564().method_11657((class_2769)property, (Comparable)Integer.valueOf(amount)), this.renderOptions));
                }
            }
        } else {
            class_2769 ageProperty = block.method_9595().method_11663("age");
            if (ageProperty instanceof class_2758) {
                class_2758 intProperty = (class_2758)ageProperty;
                Iterator iterator = intProperty.method_11898().iterator();
                while (iterator.hasNext()) {
                    int age = (Integer)iterator.next();
                    phases.add(new SimpleDisplayState((class_2680)block.method_9564().method_11657((class_2769)intProperty, (Comparable)Integer.valueOf(age)), this.renderOptions));
                }
            } else {
                phases.add(new SimpleDisplayState(block.method_9564(), this.renderOptions));
            }
        }
        return phases;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public BasicOptions getRenderOptions() {
        return this.renderOptions;
    }

    @Override
    public List<Display> getDisplayPhases() {
        return this.phases;
    }

    @Override
    public DisplayType<?> getType() {
        return (DisplayType)TYPE.get();
    }
}

