/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.common.api.util.IRenderHelper;
import net.darkhax.botanypots.common.api.data.display.math.AxisAlignedRotation;
import net.darkhax.botanypots.common.api.data.display.render.DisplayRenderer;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotRenderer
implements class_827<BotanyPotBlockEntity> {
    private static final Map<class_1792, Display> DEFAULT_SOIL_DISPLAYS = new HashMap<class_1792, Display>();
    private final class_5614.class_5615 renderContext;
    private final IRenderHelper helper;

    public BotanyPotRenderer(class_5614.class_5615 ctx) {
        this.renderContext = ctx;
        this.helper = IRenderHelper.GET;
    }

    private static AxisAlignedRotation getRotationForFace(class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11034 -> AxisAlignedRotation.Y_90;
            case class_2350.field_11043 -> AxisAlignedRotation.Y_180;
            case class_2350.field_11039 -> AxisAlignedRotation.Y_270;
            default -> AxisAlignedRotation.Y_0;
        };
    }

    public static void applyRotation(AxisAlignedRotation rotation, class_4587 pose) {
        pose.method_22907(rotation.rotation);
        pose.method_46416(rotation.offset.x(), rotation.offset.y(), rotation.offset.z());
    }

    private static boolean canRenderSoil(class_1799 stack, @Nullable class_8786<Soil> soil) {
        return !stack.method_7960() && (soil != null || stack.method_7909() instanceof class_1747);
    }

    public void render(BotanyPotBlockEntity pot, float tickDelta, @NotNull class_4587 pose, @NotNull class_4597 bufferSource, int light, int overlay) {
        class_1937 level = pot.method_10997();
        if (level == null) {
            return;
        }
        class_2338 pos = pot.method_11016();
        int maxGrowth = pot.getRequiredGrowthTicks();
        float progress = Math.max(class_3532.method_16439((float)tickDelta, (float)(pot.growthTime.getTicks() - 1.0f), (float)pot.growthTime.getTicks()) / (float)maxGrowth, 0.0f);
        AxisAlignedRotation baseRotation = BotanyPotRenderer.getRotationForFace((class_2350)pot.method_11010().method_11654((class_2769)class_2741.field_12481));
        Soil soil = pot.getOrInvalidateSoil();
        Crop crop = pot.getOrInvalidateCrop();
        boolean isGrowing = crop != null && crop.isGrowthSustained(pot.getRecipeContext(), level);
        class_1799 soilItem = pot.getSoilItem();
        float cropScale = 0.4f + Math.clamp(0.6f * progress, 0.0f, 0.6f);
        float lastOffset = 0.3984375f;
        if (isGrowing) {
            for (Display state : crop.getDisplayState(pot.getRecipeContext(), pot.method_10997())) {
                lastOffset = DisplayRenderer.renderState(this.renderContext, state, pose, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, cropScale, lastOffset);
            }
        }
        if (!soilItem.method_7960() && class_310.method_1551().method_31975().field_4344.method_19326().field_1351 >= (double)pos.method_10264() && (soil != null || crop != null && soilItem.method_7909() instanceof class_1747 && isGrowing)) {
            Display soilRender;
            pose.method_22903();
            BotanyPotRenderer.applyRotation(baseRotation, pose);
            pose.method_22905(1.0f, 0.6375f, 1.0f);
            if (soil != null) {
                v0 = soil.getDisplay(pot.getRecipeContext(), level);
            } else {
                class_1792 class_17922 = soilItem.method_7909();
                if (class_17922 instanceof class_1747) {
                    class_1747 blockItem = (class_1747)class_17922;
                    v0 = DEFAULT_SOIL_DISPLAYS.computeIfAbsent((class_1792)blockItem, i -> new SimpleDisplayState(blockItem.method_7711().method_9564(), BasicOptions.ofDefault()));
                } else {
                    v0 = soilRender = null;
                }
            }
            if (soilRender != null) {
                DisplayRenderer.renderState(this.renderContext, soilRender, pose, level, pos, tickDelta, bufferSource, light, overlay, pot, progress, 1.0f, 0.0f);
            }
            pose.method_22909();
        }
    }

    public int method_33893() {
        return 40;
    }
}

