package net.darkhax.botanypots.common.impl.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PlaceCrops {

    public static final List<Supplier<class_2248>> pots = List.of(
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("red_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("orange_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("yellow_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("lime_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("green_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("cyan_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("light_blue_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("blue_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("purple_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("magenta_concrete_waxed_botany_pot")),
            CachedSupplier.of(class_7923.field_41175, BotanyPotsMod.id("pink_concrete_waxed_botany_pot"))
    );

    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        final LiteralArgumentBuilder<class_2168> cmd = class_2170.method_9247("place_seeds");
        cmd.executes(PlaceCrops::execute);
        cmd.then(class_2170.method_9244("pos", class_2262.method_9698()).executes(PlaceCrops::execute).then(class_2170.method_9244("all_soils", BoolArgumentType.bool()).executes(PlaceCrops::execute)));
        parent.then(cmd);
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        final class_2338.class_2339 mutable = CommandHelper.hasArgument("pos", ctx) ? class_2262.method_9696(ctx, "pos").method_25503() : ctx.getSource().method_9207().method_23312().method_25503();
        final boolean allSoils = CommandHelper.hasArgument("all_soils", ctx) && BoolArgumentType.getBool(ctx, "all_soils");
        final class_1937 level = ctx.getSource().method_9225();
        int count = 0;
        for (Map.Entry<class_1792, class_8786<Crop>> crop : Objects.requireNonNull(Crop.CACHE.apply(ctx.getSource().method_9225())).getCachedValues().entries().stream().sorted(Comparator.comparing(s -> class_7923.field_41178.method_10221(s.getKey()).toString())).collect(Collectors.toCollection(LinkedHashSet::new))) {

            if (allSoils) {
                for (class_1799 soilStack : findAllSoils(crop.getValue().comp_1933())) {
                    level.method_8652(mutable, pots.get(count).get().method_9564(), 3);
                    if (level.method_8321(mutable) instanceof BotanyPotBlockEntity pot) {
                        pot.method_5447(0, soilStack);
                        pot.method_5447(1, crop.getKey().method_7854());
                        pot.updateGrowthTime(pot.getRequiredGrowthTicks());
                    }
                    count++;
                    mutable.method_10098(class_2350.field_11043);

                    if (count == pots.size()) {
                        count = 0;
                        mutable.method_10104(class_2350.field_11035, pots.size());
                        mutable.method_10098(class_2350.field_11034);
                    }
                }
            }
            else {
                level.method_8652(mutable, pots.get(count).get().method_9564(), 3);
                if (level.method_8321(mutable) instanceof BotanyPotBlockEntity pot) {
                    pot.method_5447(0, findFirstSoil(crop.getValue().comp_1933()));
                    pot.method_5447(1, crop.getKey().method_7854());
                    pot.updateGrowthTime(pot.getRequiredGrowthTicks());
                }
                count++;
                mutable.method_10098(class_2350.field_11043);

                if (count == pots.size()) {
                    count = 0;
                    mutable.method_10104(class_2350.field_11035, pots.size());
                    mutable.method_10098(class_2350.field_11034);
                }
            }
        }
        return 0;
    }

    private static List<class_1799> findAllSoils(Crop crop) {
        final List<class_1799> items = new ArrayList<>();
        if (crop instanceof BasicCrop basic) {
            for (class_1792 item : class_7923.field_41178) {
                final class_1799 stack = item.method_7854();
                if (basic.getBasicProperties().soil().method_8093(stack)) {
                    items.add(stack);
                }
            }
        }
        return items;
    }

    private static class_1799 findFirstSoil(Crop crop) {
        if (crop instanceof BasicCrop basic) {
            for (class_1792 item : class_7923.field_41178) {
                final class_1799 stack = item.method_7854();
                if (basic.getBasicProperties().soil().method_8093(stack)) {
                    return stack;
                }
            }
        }
        return class_1799.field_8037;
    }
}