/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.BotanyPotsPlugin;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.crop.CropGenerator;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.command.generator.MissingCropGenerator;
import net.darkhax.botanypots.common.impl.command.generator.MissingSoilGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import org.apache.commons.io.FileUtils;

public class MissingCommand {
    private static final CachedSupplier<Map<ResourceLocation, SoilGenerator>> SOIL_GENERATORS = CachedSupplier.cache(() -> {
        LinkedHashMap<ResourceLocation, MissingSoilGenerator> generators = new LinkedHashMap<ResourceLocation, MissingSoilGenerator>();
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(plugin -> plugin.registerSoilGenerators(generators::put));
        generators.put(BotanyPotsMod.id("missing_fallback"), new MissingSoilGenerator());
        return generators;
    });
    private static final CachedSupplier<Map<ResourceLocation, CropGenerator>> CROP_GENERATORS = CachedSupplier.cache(() -> {
        LinkedHashMap<ResourceLocation, MissingCropGenerator> generators = new LinkedHashMap<ResourceLocation, MissingCropGenerator>();
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(plugin -> plugin.registerCropGenerators(generators::put));
        generators.put(BotanyPotsMod.id("missing_fallback"), new MissingCropGenerator());
        return generators;
    });
    private static final TagKey<Item> SAPLING_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"saplings"));
    private static final Comparator<ResourceLocation> ID_COMPARE = Comparator.comparing(ResourceLocation::toString);

    public static void build(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder cmd = Commands.literal((String)"missing");
        LiteralArgumentBuilder seeds = Commands.literal((String)"seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(((RequiredArgumentBuilder)Commands.argument((String)"include_saplings", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)).then(Commands.argument((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then((ArgumentBuilder)seeds);
        LiteralArgumentBuilder soils = Commands.literal((String)"soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(Commands.argument((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then((ArgumentBuilder)soils);
        parent.then((ArgumentBuilder)cmd);
    }

    private static Map<ItemStack, SoilGenerator> collectMissingSoilItems(ServerLevel level) {
        HashMap<ItemStack, SoilGenerator> missing = new HashMap<ItemStack, SoilGenerator>();
        block0: for (Item item : BuiltInRegistries.ITEM) {
            ItemStack stack = item.getDefaultInstance();
            if (MissingCommand.isSoil(stack, (Level)level) || MissingCommand.isCrop(stack, (Level)level)) continue;
            for (SoilGenerator generator : ((Map)SOIL_GENERATORS.get()).values()) {
                if (!generator.canGenerateSoil(level, stack)) continue;
                missing.put(stack, generator);
                continue block0;
            }
        }
        return missing;
    }

    private static int dumpMissingSoils(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Map<ItemStack, SoilGenerator> missing = MissingCommand.collectMissingSoilItems(level);
        if (missing.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outDir = MissingCommand.setupDir("botanypots/generated/soils");
            for (Map.Entry<ItemStack, SoilGenerator> entry2 : missing.entrySet()) {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry2.getKey().getItem());
                File soilFile = new File(outDir, itemId.getNamespace() + "/soil/" + itemId.getPath() + ".json");
                JsonObject obj = entry2.getValue().generateData(level, entry2.getKey());
                MissingCommand.writeFile(soilFile, DataHelper.GSON.toJson((JsonElement)obj));
            }
        }
        StringJoiner entries = new StringJoiner(System.lineSeparator());
        entries.add("Potential missing soil IDs");
        missing.keySet().stream().map(stack -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).sorted(Comparator.comparing(ResourceLocation::toString)).forEach(entry -> entries.add(entry.toString()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.missing_soils", (Object[])new Object[]{Component.literal((String)Integer.toString(missing.size())).withStyle(style -> style.withColor(ChatFormatting.RED))}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
        return missing.size();
    }

    private static Map<ItemStack, CropGenerator> collectMissingCropItems(boolean collectSaplings, ServerLevel level) {
        HashMap<ItemStack, CropGenerator> missing = new HashMap<ItemStack, CropGenerator>();
        block0: for (Item item : BuiltInRegistries.ITEM) {
            ItemStack stack = item.getDefaultInstance();
            if (MissingCommand.isSoil(stack, (Level)level) || MissingCommand.isCrop(stack, (Level)level) || !collectSaplings && MissingCommand.isSapling(item)) continue;
            for (CropGenerator generator : ((Map)CROP_GENERATORS.get()).values()) {
                if (!generator.canGenerateCrop(level, stack)) continue;
                missing.put(stack, generator);
                continue block0;
            }
        }
        return missing;
    }

    private static int dumpMissingCrops(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        boolean includeSaplings = CommandHelper.getBooleanArg((String)"include_saplings", ctx, () -> false);
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Map<ItemStack, CropGenerator> missingCrops = MissingCommand.collectMissingCropItems(includeSaplings, level);
        if (missingCrops.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outdir = MissingCommand.setupDir("botanypots/generated/crops");
            for (Map.Entry<ItemStack, CropGenerator> entry : missingCrops.entrySet()) {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry.getKey().getItem());
                File cropFile = new File(outdir, itemId.getNamespace() + "/crop/" + itemId.getPath() + ".json");
                MissingCommand.writeFile(cropFile, DataHelper.GSON.toJson((JsonElement)entry.getValue().generateData(level, entry.getKey())));
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.botanypots.dump.generated").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, outdir.getAbsolutePath()))), false);
        } else {
            StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach((k, v) -> entries.add(BuiltInRegistries.ITEM.getKey((Object)k.getItem()).toString()));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{Component.literal((String)Integer.toString(missingCrops.size())).withStyle(style -> style.withColor(ChatFormatting.RED))}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
        }
        return missingCrops.size();
    }

    private static void processTag(TagKey<Item> key, Consumer<Item> consumer) {
        BuiltInRegistries.ITEM.getTag(key).ifPresent(named -> named.forEach(entry -> consumer.accept((Item)entry.value())));
    }

    private static boolean isCrop(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(Item item) {
        BlockItem blockItem;
        return item.getDefaultInstance().is(SAPLING_TAG) || item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SaplingBlock;
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File setupDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", (Object)dir, (Object)e);
            }
        }
        file.mkdirs();
        return file;
    }
}

