/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.botanypots.common.api.command.generator.DataHelper;
import net.darkhax.botanypots.common.api.command.generator.soil.SoilGenerator;
import net.darkhax.botanypots.common.api.command.generator.soil.TaggedSoilGenerator;
import net.darkhax.botanypots.common.api.data.recipes.RecipeCache;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.command.generator.MissingSoilGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.io.FileUtils;

public class MissingCommand {
    public static SoilGenerator MISSING_BLOCK = new MissingSoilGenerator();
    public static SoilGenerator WATER = new TaggedSoilGenerator("botanypots:soil/water", DataHelper.simpleDisplay(Blocks.WATER, true));
    public static SoilGenerator LAVA = new TaggedSoilGenerator("botanypots:soil/lava", DataHelper.simpleDisplay(Blocks.LAVA, true));
    public static SoilGenerator SNOW = new TaggedSoilGenerator("botanypots:soil/snow", DataHelper.simpleDisplay(Blocks.SNOW_BLOCK));
    private static final Comparator<ResourceLocation> ID_COMPARE = Comparator.comparing(ResourceLocation::toString);
    private static final TagKey<Item> FORGE_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"seeds"));
    private static final TagKey<Item> COMMON_SEEDS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"seeds"));
    private static final ReloadableCache<Set<Item>> IGNORED_ITEMS = ReloadableCache.of(() -> {
        HashSet<Item> items = new HashSet<Item>();
        items.add(Items.DEAD_BUSH);
        items.add(Items.MANGROVE_LEAVES);
        items.add(Items.NETHERRACK);
        items.add(Items.ROOTED_DIRT);
        items.add(Items.GRASS_BLOCK);
        items.add(Items.WARPED_NYLIUM);
        items.add(Items.CRIMSON_NYLIUM);
        return items;
    });
    public static final String SEED_TEMPLATE = "{\n  \"bookshelf:load_conditions\": [\n    {\n      \"type\": \"bookshelf:block_exists\",\n      \"values\": [\n        \"$block_id$\"\n      ]\n    }\n  ],\n  \"type\": \"botanypots:block_derived_crop\",\n  \"block\": \"$block_id$\"\n}\n";

    public static void build(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder cmd = Commands.literal((String)"missing");
        LiteralArgumentBuilder seeds = Commands.literal((String)"seeds");
        seeds.executes(MissingCommand::dumpMissingCrops);
        seeds.then(((RequiredArgumentBuilder)Commands.argument((String)"include_saplings", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)).then(Commands.argument((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingCrops)));
        cmd.then((ArgumentBuilder)seeds);
        LiteralArgumentBuilder soils = Commands.literal((String)"soils");
        soils.executes(MissingCommand::dumpMissingSoils);
        soils.then(Commands.argument((String)"generate", (ArgumentType)BoolArgumentType.bool()).executes(MissingCommand::dumpMissingSoils));
        cmd.then((ArgumentBuilder)soils);
        parent.then((ArgumentBuilder)cmd);
    }

    private static int dumpMissingSoils(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        SoilGenerator[] generators = new SoilGenerator[]{SNOW, LAVA, WATER, MISSING_BLOCK};
        HashMap<ItemStack, SoilGenerator> missing = new HashMap<ItemStack, SoilGenerator>();
        block0: for (Item item : BuiltInRegistries.ITEM) {
            ItemStack stack2 = item.getDefaultInstance();
            if (MissingCommand.isSoil(stack2, (Level)level)) continue;
            for (SoilGenerator generator : generators) {
                if (!generator.canGenerateSoil((Level)level, stack2)) continue;
                missing.put(stack2, generator);
                continue block0;
            }
        }
        if (missing.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            MissingCommand.generateMissingSoils(level, missing);
        }
        StringJoiner entries = new StringJoiner(System.lineSeparator());
        entries.add("Potential missing soil IDs");
        missing.keySet().stream().map(stack -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).sorted(Comparator.comparing(ResourceLocation::toString)).forEach(entry -> entries.add(entry.toString()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.missing_soils", (Object[])new Object[]{Component.literal((String)Integer.toString(missing.size())).withStyle(style -> style.withColor(ChatFormatting.RED))}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
        return 0;
    }

    private static void generateMissingSoils(ServerLevel level, Map<ItemStack, SoilGenerator> missing) {
        File outDir = MissingCommand.setupDir("botanypots/generated/soils");
        for (Map.Entry<ItemStack, SoilGenerator> entry : missing.entrySet()) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry.getKey().getItem());
            File soilFile = new File(outDir, itemId.getNamespace() + "/soil/" + itemId.getPath() + ".json");
            JsonObject obj = entry.getValue().generateData((Level)level, entry.getKey());
            MissingCommand.writeFile(soilFile, DataHelper.GSON.toJson((JsonElement)obj));
        }
    }

    private static int dumpMissingCrops(CommandContext<CommandSourceStack> ctx) {
        boolean includeSaplings = CommandHelper.getBooleanArg((String)"include_saplings", ctx, () -> false);
        boolean generate = CommandHelper.getBooleanArg((String)"generate", ctx, () -> false);
        Set<ResourceLocation> missingCrops = MissingCommand.getMissingCrops((Level)((CommandSourceStack)ctx.getSource()).getLevel(), includeSaplings);
        if (missingCrops.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.no_results")), false);
            return 0;
        }
        if (generate) {
            File outdir = MissingCommand.setupDir("botanypots/generated/crops");
            for (ResourceLocation itemId : missingCrops) {
                Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
                if (!(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock());
                File cropFile = new File(outdir, blockId.getNamespace() + "/crop/" + blockId.getPath() + ".json");
                MissingCommand.writeFile(cropFile, SEED_TEMPLATE.replace("$block_id$", blockId.toString()));
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.botanypots.dump.generated").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, outdir.getAbsolutePath()))), false);
        } else {
            StringJoiner entries = new StringJoiner(System.lineSeparator());
            entries.add("Potential missing crop IDs");
            missingCrops.forEach(entry -> entries.add(entry.toString()));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> BotanyPotsCommands.modMessage((Component)Component.translatable((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{Component.literal((String)Integer.toString(missingCrops.size())).withStyle(style -> style.withColor(ChatFormatting.RED))}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, entries.toString())))), false);
        }
        return 0;
    }

    private static Set<ResourceLocation> getMissingCrops(Level level, boolean includeSaplings) {
        HashSet<Item> missingSeedItems = new HashSet<Item>();
        block0: for (Item item2 : BuiltInRegistries.ITEM) {
            if (MissingCommand.isCrop(item2.getDefaultInstance(), level) || MissingCommand.isSoil(item2.getDefaultInstance(), level) || !(item2 instanceof BlockItem)) continue;
            BlockItem itemBlock = (BlockItem)item2;
            Block placedBlock = itemBlock.getBlock();
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)placedBlock);
            if (placedBlock instanceof CropBlock || placedBlock instanceof GrowingPlantBlock || placedBlock instanceof BonemealableBlock || placedBlock instanceof SaplingBlock || placedBlock instanceof BushBlock || placedBlock instanceof SporeBlossomBlock || placedBlock instanceof BaseCoralPlantTypeBlock && !blockId.getPath().startsWith("dead_")) {
                missingSeedItems.add(item2);
                continue;
            }
            for (Property property : placedBlock.getStateDefinition().getProperties()) {
                if (!property.getName().equalsIgnoreCase("age")) continue;
                missingSeedItems.add(item2);
                continue block0;
            }
        }
        Consumer<Item> tagProcessor = item -> {
            if (!MissingCommand.isCrop(item.getDefaultInstance(), level) && !MissingCommand.isSoil(item.getDefaultInstance(), level)) {
                missingSeedItems.add((Item)item);
            }
        };
        MissingCommand.processTag(FORGE_SEEDS, tagProcessor);
        MissingCommand.processTag(COMMON_SEEDS, tagProcessor);
        return missingSeedItems.stream().filter(item -> (includeSaplings || !MissingCommand.isSapling(item)) && !Objects.requireNonNull((Set)IGNORED_ITEMS.apply(level)).contains(item)).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).sorted(ID_COMPARE).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void processTag(TagKey<Item> key, Consumer<Item> consumer) {
        BuiltInRegistries.ITEM.getTag(key).ifPresent(named -> named.forEach(entry -> consumer.accept((Item)entry.value())));
    }

    private static boolean isCrop(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Crop.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSoil(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Soil.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isFertilizer(ItemStack stack, Level level) {
        return Objects.requireNonNull((RecipeCache)Fertilizer.CACHE.apply(level)).isCached(stack);
    }

    private static boolean isSapling(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SaplingBlock;
    }

    private static void writeFile(File file, String text) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File setupDir(String dir) {
        File file = new File(dir);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                BotanyPotsMod.LOG.error("Failed to setup dir {}.", (Object)dir, (Object)e);
            }
        }
        file.mkdirs();
        return file;
    }
}

