/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.growthamount;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.api.data.growthamount.GrowthAmount;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record GrowthAmountType<T extends GrowthAmount>(ResourceLocation typeID, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> stream) {
    private static final Map<ResourceLocation, GrowthAmountType<?>> REGISTRY = new HashMap();
    public static final Codec<GrowthAmountType<?>> TYPE_CODEC = ResourceLocation.CODEC.xmap(REGISTRY::get, GrowthAmountType::typeID);
    public static final StreamCodec<ByteBuf, ? extends GrowthAmountType<?>> TYPE_STREAM = ResourceLocation.STREAM_CODEC.map(REGISTRY::get, GrowthAmountType::typeID);
    public static final Codec<GrowthAmount> GROWTH_AMOUNT_CODEC = TYPE_CODEC.dispatch(GrowthAmount::getType, GrowthAmountType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, GrowthAmount> GROWTH_AMOUNT_STREAM = StreamCodec.of((buf, val) -> {
        buf.writeResourceLocation(val.getType().typeID());
        val.getType().stream.encode(buf, val);
    }, buf -> {
        ResourceLocation id = buf.readResourceLocation();
        if (!REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.error("Growth type {} does not exist!", (Object)id);
            throw new IllegalStateException("Growth type " + String.valueOf(id) + " does not exist.");
        }
        return (GrowthAmount)GrowthAmountType.REGISTRY.get((Object)id).stream.decode(buf);
    });

    public static Supplier<GrowthAmountType<?>> getLazy(ResourceLocation id) {
        return CachedSupplier.cache(() -> GrowthAmountType.get(id));
    }

    public static GrowthAmountType<?> get(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    public static <T extends GrowthAmount> GrowthAmountType<T> register(ResourceLocation id, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> stream) {
        GrowthAmountType<T> type = new GrowthAmountType<T>(id, codec, stream);
        if (REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.warn("Growth type {} has already been assigned to {}. Replacing it with {}.", new Object[]{id, REGISTRY.get(id), type});
        }
        REGISTRY.put(id, type);
        return type;
    }
}

