/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import net.darkhax.bookshelf.common.api.block.IBlockHooks;
import net.darkhax.botanypots.common.api.data.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.common.api.data.recipes.interaction.PotInteraction;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotanyPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
IBlockHooks {
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    public static final ToIntFunction<BlockState> LIGHT_LEVEL = state -> (Integer)state.getValue((Property)BlockStateProperties.LEVEL);
    public final PotType type;

    public BotanyPotBlock(MapColor color, PotType type) {
        this(BlockBehaviour.Properties.of().mapColor(color).strength(1.25f, 4.2f).noOcclusion().lightLevel(LIGHT_LEVEL), type);
    }

    public BotanyPotBlock(BlockBehaviour.Properties properties, PotType type) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.type = type;
    }

    public boolean isHopper() {
        return this.type == PotType.HOPPER;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (this.type != PotType.WAXED && (blockEntity = level.getBlockEntity(pos)) instanceof BotanyPotBlockEntity) {
            BotanyPotBlockEntity pot = (BotanyPotBlockEntity)blockEntity;
            BlockEntityContext context = new BlockEntityContext(pot, player, hand);
            if (this.type == PotType.BASIC && pot.canHarvest()) {
                pot.growthTime.reset();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    pot.getOrInvalidateCrop().onHarvest(pot.getRecipeContext(), level, dropOutput -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)dropOutput));
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)pot.getBlockState()));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            RecipeHolder<Fertilizer> fertilizer = Fertilizer.getFertilizer(level, context, player.getItemInHand(hand));
            if (fertilizer != null && ((Fertilizer)fertilizer.value()).matches(context, level)) {
                ((Fertilizer)fertilizer.value()).apply(context, level);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            RecipeHolder<PotInteraction> interaction = PotInteraction.getInteraction(level, context, player.getItemInHand(hand));
            if (interaction != null && ((PotInteraction)interaction.value()).matches(context, level)) {
                ((PotInteraction)interaction.value()).apply(context);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        this.openMenu(state, level, pos, player);
        return ItemInteractionResult.CONSUME;
    }

    public void openMenu(BlockState state, Level level, BlockPos pos, Player player) {
        MenuProvider menuprovider = this.getMenuProvider(state, level, pos);
        if (menuprovider != null) {
            player.openMenu(menuprovider);
        }
    }

    @Nullable
    protected MenuProvider getMenuProvider(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BotanyPotBlockEntity) {
            BotanyPotBlockEntity pot = (BotanyPotBlockEntity)blockEntity;
            return pot;
        }
        return super.getMenuProvider(state, level, pos);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return BotanyPotBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BotanyPotBlockEntity.TYPE.get()), BotanyPotBlockEntity::tickPot);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new RuntimeException("Codecs for this block have not been implemented yet. Sorry :(");
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos placedPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(placedPos);
        BlockState placedState = (BlockState)super.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        if (context.getNearestLookingDirection().getAxis().isHorizontal()) {
            placedState = (BlockState)placedState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
        }
        return placedState;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BotanyPotBlockEntity) {
            BotanyPotBlockEntity pot = (BotanyPotBlockEntity)blockEntity;
            n = pot.comparatorLevel;
        } else {
            n = 0;
        }
        return n;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, BlockStateProperties.LEVEL, BlockStateProperties.HORIZONTAL_FACING});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new BotanyPotBlockEntity(pos, state);
    }
}

