/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.codecs.stream.StreamCodecs;
import net.darkhax.bookshelf.common.api.data.enchantment.EnchantmentLevel;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.context.BlockEntityContext;
import net.darkhax.botanypots.common.api.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.recipes.crop.Crop;
import net.darkhax.botanypots.common.api.data.recipes.soil.Soil;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Helpers {
    public static final Codec<Block> BLOCK_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0));
    public static final StreamCodec<ByteBuf, Block> BLOCK_STREAM = ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0));
    public static final Codec<Item> ITEM_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
    public static final StreamCodec<ByteBuf, Item> ITEM_STREAM = ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
    public static final Codec<EntityType<?>> ENTITY_TYPE_CODEC = ResourceLocation.CODEC.xmap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0));
    public static final StreamCodec<ByteBuf, EntityType<?>> ENTITY_TYPE_STREAM = ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0));
    public static final StreamCodec<ByteBuf, BlockState> BLOCK_STATE_STREAM = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> OPTIONAL_INGREDIENT_STREAM = DataHelper.optionalStream((StreamCodec)StreamCodecs.INGREDIENT_NON_EMPTY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<ItemStack>> OPTIONAL_ITEMSTACK_STREAM = DataHelper.optionalStream((StreamCodec)ItemStack.STREAM_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<BlockPredicate>> OPTIONAL_BLOCK_PREDICATE = DataHelper.optionalStream((StreamCodec)BlockPredicate.STREAM_CODEC);
    public static final StreamCodec<ByteBuf, TagKey<Block>> BLOCK_TAG = ResourceLocation.STREAM_CODEC.map(rl -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)rl), TagKey::location);
    public static final TagKey<Enchantment> INCREASE_POT_GROWTH_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)BotanyPotsMod.id("increase_pot_growth"));
    public static final TagKey<Enchantment> NEGATE_HARVEST_DAMAGE_TAG = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)BotanyPotsMod.id("negate_harvest_damage"));
    public static final Supplier<Holder<Attribute>> GROWTH_MOD_ATTRIBUTE = CachedSupplier.cache(() -> (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(BotanyPotsMod.id("growth")).orElseThrow());
    public static final String GROWTH_MODIFIER_KEY = "tooltip.botanypots.growth_modifier";
    public static final Supplier<Holder<Attribute>> YIELD_MOD_ATTRIBUTE = CachedSupplier.cache(() -> (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(BotanyPotsMod.id("yield")).orElseThrow());
    public static final String YIELD_MODIFIER_KEY = "tooltip.botanypots.yield_modifier";

    public static Component modifierComponent(String key, float modifier) {
        if (modifier > 0.0f) {
            return Component.translatable((String)key, (Object[])new Object[]{"+" + MathsHelper.DECIMAL_2.format((double)modifier * 100.0) + "%"}).withStyle(ChatFormatting.BLUE);
        }
        return Component.translatable((String)key, (Object[])new Object[]{"-" + MathsHelper.DECIMAL_2.format((double)modifier * 100.0) + "%"}).withStyle(ChatFormatting.RED);
    }

    public static Component indent(Component base) {
        return Component.literal((String)"  ").append(base);
    }

    public static int getRequiredGrowthTicks(BotanyPotContext context, Level level, Crop crop, @Nullable Soil soil) {
        BlockEntityContext beContext;
        Block block;
        float cropTime = crop.getRequiredGrowthTicks(context, level);
        float growthModifier = ((Config)BotanyPotsMod.CONFIG.get()).gameplay.global_growth_modifier;
        growthModifier += soil != null ? soil.getGrowthModifier(context, level) : 0.0f;
        growthModifier += Helpers.efficiencyModifier(level.registryAccess(), context.getHarvestItem());
        if (context instanceof BlockEntityContext && (block = (beContext = (BlockEntityContext)context).pot().getBlockState().getBlock()) instanceof BotanyPotBlock) {
            BotanyPotBlock potBlock = (BotanyPotBlock)block;
            growthModifier += potBlock.getGrowthModifier(context, level, crop, soil);
        }
        return Mth.floor((float)(cropTime / growthModifier));
    }

    public static float getTotalYield(BotanyPotContext context, Level level, Crop crop, @Nullable Soil soil) {
        BlockEntityContext beContext;
        Block block;
        float yieldScale = crop.getYieldScale(context, level);
        float yield = crop.getBaseYield(context, level);
        if (context instanceof BlockEntityContext && (block = (beContext = (BlockEntityContext)context).pot().getBlockState().getBlock()) instanceof BotanyPotBlock) {
            BotanyPotBlock potBlock = (BotanyPotBlock)block;
            yield += yieldScale * potBlock.getYieldModifier(context, level, crop, soil);
        }
        if (soil != null) {
            yield += yieldScale * soil.getYieldModifier(context, level);
        }
        return yield += yieldScale * (float)Helpers.getAttributeValue(YIELD_MOD_ATTRIBUTE.get(), context.getHarvestItem(), 0.0f);
    }

    public static int getLootRolls(BotanyPotContext context, Level level, Crop crop, @Nullable Soil soil) {
        return Helpers.determineRollCount(Helpers.getTotalYield(context, level, crop, soil), level.getRandom());
    }

    public static int determineRollCount(float chance, RandomSource rng) {
        int guaranteedRolls = (int)Math.floor(chance);
        float remainingChance = chance % 1.0f;
        if (rng.nextFloat() < remainingChance) {
            ++guaranteedRolls;
        }
        return Math.max(0, guaranteedRolls);
    }

    public static int chanceToInt(float chance) {
        return (int)Math.floor(chance * 100.0f);
    }

    public static MutableComponent withScale(MutableComponent base, float scale) {
        if (scale != 1.0f) {
            base.append(" (").append((Component)Component.translatable((String)"tooltip.botanypots.percent", (Object[])new Object[]{Helpers.chanceToInt(scale)}).withStyle(scale > 1.0f ? ChatFormatting.GREEN : ChatFormatting.RED)).append(")");
        }
        return base;
    }

    public static float efficiencyModifier(RegistryAccess registryAccess, ItemStack stack) {
        float modifier = 0.0f;
        modifier += (float)EnchantmentLevel.HIGHEST.get(INCREASE_POT_GROWTH_TAG, stack) * ((Config)BotanyPotsMod.CONFIG.get()).gameplay.efficiency_growth_modifier;
        return modifier += (float)Helpers.getAttributeValue(GROWTH_MOD_ATTRIBUTE.get(), stack, 0.0f);
    }

    public static double getAttributeValue(Holder<Attribute> attribute, ItemStack stack, float defaultValue) {
        double value = 0.0;
        ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            if (entry.attribute() != attribute) continue;
            double entryAmount = entry.modifier().amount();
            value += (switch (entry.modifier().operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> entryAmount;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> entryAmount * (double)defaultValue;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> entryAmount * value;
            });
        }
        return value;
    }
}

