/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.itemdrops;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.data.itemdrops.BlockDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.BlockStateDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.EntityDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.LootTableDrops;
import net.darkhax.botanypots.common.impl.data.itemdrops.SimpleDropProvider;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record ItemDropProviderType<T extends ItemDropProvider>(ResourceLocation typeID, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> stream) {
    private static final Map<ResourceLocation, ItemDropProviderType<?>> REGISTRY = new HashMap();
    public static final Codec<ItemDropProviderType<?>> TYPE_CODEC = ResourceLocation.CODEC.xmap(REGISTRY::get, ItemDropProviderType::typeID);
    public static final StreamCodec<ByteBuf, ? extends ItemDropProviderType<?>> TYPE_STREAM = ResourceLocation.STREAM_CODEC.map(REGISTRY::get, ItemDropProviderType::typeID);
    public static final ItemDropProviderType<LootTableDrops> LOOT_TABLE = ItemDropProviderType.register(BotanyPotsMod.id("loot_table"), LootTableDrops.CODEC, LootTableDrops.STREAM);
    public static final ItemDropProviderType<SimpleDropProvider> SIMPLE_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("items"), SimpleDropProvider.CODEC, SimpleDropProvider.STREAM);
    public static final ItemDropProviderType<BlockDrops> BLOCK_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("block"), BlockDrops.CODEC, BlockDrops.STREAM);
    public static final ItemDropProviderType<BlockStateDrops> BLOCK_STATE_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("block_state"), BlockStateDrops.CODEC, BlockStateDrops.STREAM);
    public static final ItemDropProviderType<EntityDrops> ENTITY_DROPS = ItemDropProviderType.register(BotanyPotsMod.id("entity"), EntityDrops.CODEC, EntityDrops.STREAM);
    public static final Codec<ItemDropProvider> DROP_PROVIDER_CODEC = TYPE_CODEC.dispatch(ItemDropProvider::getType, ItemDropProviderType::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemDropProvider> DROP_PROVIDER_STREAM = new StreamCodec<RegistryFriendlyByteBuf, ItemDropProvider>(){

        public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull ItemDropProvider dropProvider) {
            buf.writeResourceLocation(dropProvider.getType().typeID());
            dropProvider.getType().stream.encode((Object)buf, (Object)dropProvider);
        }

        @NotNull
        public ItemDropProvider decode(@NotNull RegistryFriendlyByteBuf buf) {
            ResourceLocation id = buf.readResourceLocation();
            if (!REGISTRY.containsKey(id)) {
                BotanyPotsMod.LOG.error("Drop provider {} does not exist!", (Object)id);
                throw new IllegalStateException("Drop provider " + String.valueOf(id) + " does not exist.");
            }
            return (ItemDropProvider)ItemDropProviderType.REGISTRY.get((Object)id).stream.decode((Object)buf);
        }
    };
    public static final Codec<List<ItemDropProvider>> LIST_CODEC = MapCodecs.flexibleList(DROP_PROVIDER_CODEC);

    public static <T extends ItemDropProvider> ItemDropProviderType<T> register(ResourceLocation id, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> stream) {
        ItemDropProviderType<T> type = new ItemDropProviderType<T>(id, codec, stream);
        if (REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.warn("Item drop provider {} has already been assigned to {}. Replacing it with {}.", new Object[]{id, REGISTRY.get(id), type});
        }
        REGISTRY.put(id, type);
        return type;
    }
}

