/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorCropBlock;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.data.display.types.AgingDisplayState;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.darkhax.botanypots.common.impl.data.itemdrops.BlockStateDrops;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.mixin.AccessorIntegerProperty;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockDerivedCrop
extends BasicCrop {
    public static final MapCodec<BlockDerivedCrop> CODEC = Properties.CODEC.xmap(BlockDerivedCrop::new, BlockDerivedCrop::getProperties);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockDerivedCrop> STREAM = Properties.STREAM.map(BlockDerivedCrop::new, BlockDerivedCrop::getProperties);
    public static final RecipeSerializer<BlockDerivedCrop> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    private final Properties properties;

    public BlockDerivedCrop(Properties properties) {
        super(properties.toBasic());
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public record Properties(Block block, Optional<Ingredient> seed, Ingredient soil, int growTime, Optional<List<Display>> display, int lightLevel, Optional<List<ItemDropProvider>> drops, Optional<BasicOptions> renderOptions, Optional<ResourceLocation> functionId, Optional<BlockPredicate> potPredicate) {
        public static final MapCodec<Properties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(Properties::block), (App)Ingredient.CODEC.optionalFieldOf("input").forGetter(Properties::seed), (App)Ingredient.CODEC.optionalFieldOf("soil", (Object)BasicCrop.DIRT).forGetter(Properties::soil), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("grow_time", (Object)1200).forGetter(Properties::growTime), (App)DisplayType.LIST_CODEC.optionalFieldOf("display").forGetter(Properties::display), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(Properties::lightLevel), (App)MapCodecs.flexibleList(ItemDropProviderType.DROP_PROVIDER_CODEC).optionalFieldOf("drops").forGetter(Properties::drops), (App)BasicOptions.CODEC.optionalFieldOf("render_options").forGetter(Properties::renderOptions), (App)ResourceLocation.CODEC.optionalFieldOf("function").forGetter(Properties::functionId), (App)BlockPredicate.CODEC.optionalFieldOf("pot_predicate").forGetter(Properties::potPredicate)).apply((Applicative)instance, Properties::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Properties> STREAM = new StreamCodec<RegistryFriendlyByteBuf, Properties>(){

            @NotNull
            public Properties decode(@NotNull RegistryFriendlyByteBuf buf) {
                Block block = (Block)Helpers.BLOCK_STREAM.decode((Object)buf);
                BasicCrop.Properties props = (BasicCrop.Properties)BasicCrop.Properties.STREAM.decode((Object)buf);
                return Properties.fromBasic(block, props);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull Properties properties) {
                Helpers.BLOCK_STREAM.encode((Object)buf, (Object)properties.block);
                BasicCrop.Properties.STREAM.encode((Object)buf, (Object)properties.toBasic());
            }
        };

        public BasicCrop.Properties toBasic() {
            Ingredient seed = this.seed.orElseGet(() -> Properties.getSeed(this.block));
            BasicOptions rOptions = this.renderOptions.orElse(BasicOptions.ofDefault());
            List display = this.display.orElseGet(() -> {
                ArrayList<Display> states = new ArrayList<Display>();
                if (this.block.defaultBlockState().hasProperty((Property)BlockStateProperties.HALF)) {
                    states.add(new SimpleDisplayState((BlockState)this.block.defaultBlockState().setValue((Property)BlockStateProperties.HALF, (Comparable)Half.BOTTOM), rOptions));
                    states.add(new SimpleDisplayState((BlockState)this.block.defaultBlockState().setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP), rOptions));
                } else if (this.block.defaultBlockState().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                    states.add(new SimpleDisplayState((BlockState)this.block.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER), rOptions));
                    states.add(new SimpleDisplayState((BlockState)this.block.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), rOptions));
                } else {
                    states.add(new AgingDisplayState(this.block, rOptions));
                }
                return states;
            });
            List drops = this.drops.orElseGet(() -> List.of(new BlockStateDrops(Properties.getHarvestState(this.block))));
            return new BasicCrop.Properties(seed, this.soil, this.growTime, display, this.lightLevel, drops, this.functionId, this.potPredicate);
        }

        private static Properties fromBasic(Block block, BasicCrop.Properties basicProps) {
            return new Properties(block, Optional.of(basicProps.input()), basicProps.soil(), basicProps.growTime(), Optional.of(basicProps.display()), basicProps.lightLevel(), Optional.of(basicProps.drops()), Optional.empty(), basicProps.functionId(), basicProps.potPredicate());
        }

        private static BlockState getHarvestState(Block block) {
            StateDefinition stateDef = block.getStateDefinition();
            BlockState state = Properties.getAgedState(block);
            Property property = stateDef.getProperty("berries");
            if (property instanceof BooleanProperty) {
                BooleanProperty boolProp = (BooleanProperty)property;
                state = (BlockState)state.setValue((Property)boolProp, (Comparable)Boolean.valueOf(true));
            }
            if (block instanceof MultifaceBlock && block instanceof BonemealableBlock) {
                state = (BlockState)state.setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true));
            }
            return state;
        }

        private static BlockState getAgedState(Block block) {
            IntegerProperty intProp;
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                return cropBlock.getStateForAge(cropBlock.getMaxAge());
            }
            Property ageProp = block.getStateDefinition().getProperty("age");
            if (ageProp instanceof IntegerProperty && (intProp = (IntegerProperty)ageProp) instanceof AccessorIntegerProperty) {
                AccessorIntegerProperty accessor = (AccessorIntegerProperty)intProp;
                return (BlockState)block.defaultBlockState().setValue((Property)intProp, (Comparable)Integer.valueOf(accessor.botanypots$getMax()));
            }
            return block.defaultBlockState();
        }

        private static Ingredient getSeed(Block block) {
            AccessorCropBlock crop;
            ItemLike seedItem;
            if (block instanceof AccessorCropBlock && (seedItem = (crop = (AccessorCropBlock)block).bookshelf$getSeed()) != null && seedItem != Items.AIR) {
                return Ingredient.of((ItemLike[])new ItemLike[]{seedItem});
            }
            Item placer = block.asItem();
            if (placer != Items.AIR) {
                return Ingredient.of((ItemLike[])new ItemLike[]{placer});
            }
            throw new IllegalArgumentException("Can not derive seed from block " + String.valueOf(block) + " id=" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)));
        }
    }
}

