/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.itemdrops;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.util.MathsHelper;
import net.darkhax.botanypots.common.api.data.context.BotanyPotContext;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProvider;
import net.darkhax.botanypots.common.api.data.itemdrops.ItemDropProviderType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record SimpleDropProvider(List<SimpleDrop> drops) implements ItemDropProvider
{
    public static final MapCodec<SimpleDropProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapCodecs.flexibleList((Codec)SimpleDrop.CODEC.codec()).fieldOf("items").forGetter(SimpleDropProvider::drops)).apply((Applicative)instance, SimpleDropProvider::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleDropProvider> STREAM = StreamCodec.of((buffer, value) -> {
        buffer.writeInt(value.drops.size());
        for (SimpleDrop drop : value.drops) {
            SimpleDrop.STREAM.encode(buffer, (Object)drop);
        }
    }, buffer -> {
        int size = buffer.readInt();
        LinkedList<SimpleDrop> drops = new LinkedList<SimpleDrop>();
        for (int i = 0; i < size; ++i) {
            drops.add((SimpleDrop)SimpleDrop.STREAM.decode(buffer));
        }
        return new SimpleDropProvider(drops);
    });

    @Override
    public void apply(BotanyPotContext context, Level level, Consumer<ItemStack> drops) {
        for (SimpleDrop drop : this.drops) {
            if (!MathsHelper.percentChance((double)drop.chance)) continue;
            drops.accept(drop.drop().copy());
        }
    }

    @Override
    public ItemDropProviderType<?> getType() {
        return ItemDropProviderType.SIMPLE_DROPS;
    }

    @Override
    public List<ItemStack> getDisplayItems() {
        return this.drops.stream().map(d -> d.drop).collect(Collectors.toList());
    }

    public record SimpleDrop(ItemStack drop, float chance) {
        public static final MapCodec<SimpleDrop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(SimpleDrop::drop), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(SimpleDrop::chance)).apply((Applicative)instance, SimpleDrop::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SimpleDrop> STREAM = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, SimpleDrop::drop, (StreamCodec)ByteBufCodecs.FLOAT, SimpleDrop::chance, SimpleDrop::new);
    }
}

