/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.neoforge.impl;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.network.INetworkHandler;
import net.darkhax.bookshelf.common.api.registry.register.RegisterVillagerTrades;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.BookshelfMod;
import net.darkhax.bookshelf.neoforge.impl.network.NeoForgeNetworkHandler;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

@Mod(value="bookshelf")
public class NeoForgeMod {
    private final CachedSupplier<RegisterVillagerTrades> villagerTrades = CachedSupplier.cache(() -> {
        RegisterVillagerTrades register = new RegisterVillagerTrades();
        Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerTrades(register));
        return register;
    });

    public NeoForgeMod(IEventBus eventBus) {
        BookshelfMod.getInstance().init();
        NeoForge.EVENT_BUS.addListener(this::registerVillagerTrades);
        NeoForge.EVENT_BUS.addListener(this::registerWandererTrades);
        INetworkHandler iNetworkHandler = Services.NETWORK;
        if (iNetworkHandler instanceof NeoForgeNetworkHandler) {
            NeoForgeNetworkHandler handler = (NeoForgeNetworkHandler)iNetworkHandler;
            eventBus.addListener(handler::registerPayloadHandlers);
        }
    }

    private void registerVillagerTrades(VillagerTradesEvent event) {
        Multimap<Integer, VillagerTrades.ItemListing> newTrades = this.villagerTrades.get().getVillagerTrades().get(event.getType());
        if (newTrades != null && !newTrades.isEmpty()) {
            Int2ObjectMap tradeData = event.getTrades();
            for (Map.Entry entry : newTrades.entries()) {
                ((List)tradeData.computeIfAbsent((Object)((Integer)entry.getKey()), ArrayList::new)).add((VillagerTrades.ItemListing)entry.getValue());
            }
        }
    }

    private void registerWandererTrades(WandererTradesEvent event) {
        this.villagerTrades.get().getCommonWanderingTrades().forEach(event.getGenericTrades()::add);
        this.villagerTrades.get().getRareWanderingTrades().forEach(event.getRareTrades()::add);
    }
}

