/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.loot;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriber;
import net.darkhax.bookshelf.common.api.registry.register.RegisterLootDescription;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.data.loot.entries.LootItemStack;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorCompositeEntryBase;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootItem;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootPool;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootTable;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorNestedLootTable;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorTagEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import org.jetbrains.annotations.NotNull;

public class LootPoolEntryDescriptions {
    private static final CachedSupplier<List<ItemStack>> UNKNOWN_ITEM_DISPLAY = CachedSupplier.cache(() -> {
        ItemStack stack = new ItemStack((ItemLike)Items.STRUCTURE_VOID);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"tooltips.bookshelf.loot.unknown"));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(), List.of(Component.translatable((String)"tooltips.bookshelf.loot.unknown.desc").withStyle(ChatFormatting.GRAY))));
        return List.of(stack);
    });
    private static final CachedSupplier<List<ItemStack>> EMPTY_ITEM_DISPLAY = CachedSupplier.cache(() -> {
        ItemStack stack = new ItemStack((ItemLike)Items.BARRIER);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"tooltips.bookshelf.loot.empty"));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(), List.of(Component.translatable((String)"tooltips.bookshelf.loot.empty.desc").withStyle(ChatFormatting.GRAY))));
        return List.of(stack);
    });
    private static final CachedSupplier<List<ItemStack>> DYNAMIC_DISPLAY = CachedSupplier.cache(() -> {
        ItemStack stack = new ItemStack((ItemLike)Items.JIGSAW);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"tooltips.bookshelf.loot.dynamic"));
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(), List.of(Component.translatable((String)"tooltips.bookshelf.loot.dynamic.desc").withStyle(ChatFormatting.GRAY))));
        return List.of(stack);
    });
    private static final Map<LootPoolEntryType, LootPoolEntryDescriber> DESCRIBERS = new HashMap<LootPoolEntryType, LootPoolEntryDescriber>();
    private static boolean hasInitialized = false;
    public static final LootPoolEntryDescriber EMPTY = (server, entry) -> Optional.ofNullable(entry instanceof EmptyLootItem ? EMPTY_ITEM_DISPLAY.get() : null);
    public static final LootPoolEntryDescriber ITEM = (server, entry) -> {
        List<ItemStack> list;
        if (entry instanceof AccessorLootItem) {
            AccessorLootItem accessor = (AccessorLootItem)entry;
            list = List.of(new ItemStack(accessor.bookshelf$item()));
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber LOOT_TABLE = (server, entry) -> {
        List<ItemStack> list;
        if (entry instanceof AccessorNestedLootTable) {
            AccessorNestedLootTable accessor = (AccessorNestedLootTable)entry;
            list = LootPoolEntryDescriptions.getPotentialItems(server, accessor.bookshelf$contents());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber DYNAMIC = (server, entry) -> Optional.ofNullable(entry instanceof DynamicLoot ? DYNAMIC_DISPLAY.get() : null);
    public static final LootPoolEntryDescriber TAG = (server, entry) -> {
        List<ItemStack> list;
        if (entry instanceof AccessorTagEntry) {
            AccessorTagEntry tagEntry = (AccessorTagEntry)entry;
            list = LootPoolEntryDescriptions.getTagItems(tagEntry.bookshelf$tag());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber COMPOSITE = (server, entry) -> {
        List<ItemStack> list;
        if (entry instanceof AccessorCompositeEntryBase) {
            AccessorCompositeEntryBase access = (AccessorCompositeEntryBase)entry;
            list = LootPoolEntryDescriptions.getPotentialItems(server, access.bookshelf$children());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };
    public static final LootPoolEntryDescriber ITEM_STACK = (server, entry) -> {
        List<ItemStack> list;
        if (entry instanceof LootItemStack) {
            LootItemStack loot = (LootItemStack)entry;
            list = List.of(loot.getBaseStack());
        } else {
            list = null;
        }
        return Optional.ofNullable(list);
    };

    private static void bootstrap() {
        if (!hasInitialized) {
            RegisterLootDescription register = new RegisterLootDescription(DESCRIBERS::put);
            Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerLootDescriptions(register));
            hasInitialized = true;
        }
    }

    public static List<ItemStack> getPotentialItems(@NotNull RegistryAccess registries, Either<ResourceKey<LootTable>, LootTable> table) {
        LootTable resolved = (LootTable)table.map(rl -> (LootTable)registries.registryOrThrow(Registries.LOOT_TABLE).get(rl), Function.identity());
        return resolved == null ? List.of() : LootPoolEntryDescriptions.getPotentialItems(registries, resolved);
    }

    public static List<ItemStack> getPotentialItems(@NotNull RegistryAccess registries, LootTable table) {
        NonNullList items = NonNullList.create();
        if (table instanceof AccessorLootTable) {
            AccessorLootTable tableAccess = (AccessorLootTable)table;
            for (LootPool pool : tableAccess.bookshelf$pools()) {
                if (!(pool instanceof AccessorLootPool)) continue;
                AccessorLootPool poolAccess = (AccessorLootPool)pool;
                LootPoolEntryDescriptions.getPotentialItems(registries, poolAccess.bookshelf$entries()).forEach(arg_0 -> LootPoolEntryDescriptions.lambda$getPotentialItems$12((List)items, arg_0));
            }
        }
        return items;
    }

    public static List<ItemStack> getPotentialItems(@NotNull RegistryAccess registries, List<LootPoolEntryContainer> entries) {
        NonNullList items = NonNullList.create();
        for (LootPoolEntryContainer entry : entries) {
            items.addAll(LootPoolEntryDescriptions.getPotentialItems(registries, entry));
        }
        return items;
    }

    public static List<ItemStack> getPotentialItems(@NotNull RegistryAccess registries, LootPoolEntryContainer entry) {
        LootPoolEntryDescriptions.bootstrap();
        LootPoolEntryDescriber describer = DESCRIBERS.get(entry.getType());
        return describer != null ? describer.getPotentialDrops(registries, entry).orElse(UNKNOWN_ITEM_DISPLAY.get()) : UNKNOWN_ITEM_DISPLAY.get();
    }

    private static void addStacking(List<ItemStack> items, ItemStack toAdd) {
        for (ItemStack existing : items) {
            if (!Objects.equals(existing, toAdd) && !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)toAdd)) continue;
            return;
        }
        items.add(toAdd);
    }

    private static List<ItemStack> getTagItems(TagKey<Item> tag) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(tag)) {
            items.add(new ItemStack(item));
        }
        return items;
    }

    private static /* synthetic */ void lambda$getPotentialItems$12(List items, ItemStack stack) {
        LootPoolEntryDescriptions.addStacking(items, stack);
    }
}

