/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.function;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.function.ReloadableCache;
import net.darkhax.bookshelf.common.mixin.access.level.AccessorRecipeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SidedReloadableCache<T>
implements Function<Level, T> {
    private final ReloadableCache<T> client;
    private final ReloadableCache<T> server;

    public SidedReloadableCache(ReloadableCache<T> client, ReloadableCache<T> server) {
        this.client = client;
        this.server = server;
    }

    public ReloadableCache<T> getCache(Level level) {
        return level.isClientSide ? this.client : this.server;
    }

    @Override
    @Nullable
    public T apply(Level level) {
        return this.getCache(level).apply(level);
    }

    public void invalidate(Level level) {
        this.getCache(level).invalidate();
    }

    public boolean isCached(Level level) {
        return this.getCache(level).isCached();
    }

    public boolean hasGameReloaded(Level level) {
        return this.getCache(level).hasGameReloaded(level);
    }

    public void apply(Level level, Consumer<T> consumer) {
        this.getCache(level).apply(level, consumer);
    }

    public void ifPresent(Level level, Consumer<T> consumer) {
        this.getCache(level).ifPresent(level, consumer);
    }

    @Nullable
    public <R> R map(Level level, Function<T, R> mapper) {
        return this.getCache(level).map(level, mapper);
    }

    public static <T> SidedReloadableCache<T> of(Function<Level, T> cacheFunc) {
        return new SidedReloadableCache<T>(new ReloadableCache<T>(cacheFunc), new ReloadableCache<T>(cacheFunc));
    }

    public static <T extends Recipe<?>> SidedReloadableCache<Map<ResourceLocation, RecipeHolder<T>>> recipes(Supplier<RecipeType<T>> type) {
        return SidedReloadableCache.of(level -> {
            HashMap byId = new HashMap();
            RecipeManager patt0$temp = level.getRecipeManager();
            if (patt0$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt0$temp;
                Collection recipes = accessor.bookshelf$byTypeMap().get((Object)((RecipeType)type.get()));
                recipes.forEach(entry -> byId.put(entry.id(), entry));
            }
            return byId;
        });
    }
}

