/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.function;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.IReloadTracking;
import net.darkhax.bookshelf.common.mixin.access.level.AccessorRecipeManager;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ReloadableCache<T>
implements Function<Level, T>,
IReloadTracking {
    public static final ReloadableCache EMPTY = ReloadableCache.of((Level level) -> null);
    private final Function<Level, T> delegate;
    private WeakReference<RecipeManager> recipeManager = new WeakReference<Object>(null);
    private boolean cached = false;
    private int revision = 0;
    @Nullable
    private T cachedValue;

    protected ReloadableCache(Function<Level, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public T apply(Level level) {
        if (!this.isCached() || this.hasGameReloaded(level)) {
            this.recipeManager = new WeakReference<RecipeManager>(level.getRecipeManager());
            this.cachedValue = this.delegate.apply(level);
            RecipeManager recipeManager = level.getRecipeManager();
            if (recipeManager instanceof IReloadTracking) {
                IReloadTracking reload = (IReloadTracking)recipeManager;
                this.bookshelf$setRevision(reload.bookshelf$getRevision());
            }
            this.cached = true;
        }
        return this.cachedValue;
    }

    public void invalidate() {
        this.cached = false;
        this.cachedValue = null;
        this.recipeManager = new WeakReference<Object>(null);
    }

    public boolean isCached() {
        return this.cached;
    }

    public boolean hasGameReloaded(Level level) {
        return this.recipeManager.get() != level.getRecipeManager() || !IReloadTracking.areSameRevision(this, level.getRecipeManager());
    }

    public void apply(Level level, Consumer<T> consumer) {
        consumer.accept(this.apply(level));
    }

    public void ifPresent(Level level, Consumer<T> consumer) {
        T value = this.apply(level);
        if (value != null) {
            consumer.accept(value);
        }
    }

    @Nullable
    public <R> R map(Level level, Function<T, R> mapper) {
        T value = this.apply(level);
        return value != null ? (R)mapper.apply(value) : null;
    }

    public static <T> ReloadableCache<T> of(Supplier<T> supplier) {
        return new ReloadableCache<Object>(level -> supplier.get());
    }

    public static <T> ReloadableCache<T> of(Function<Level, T> delegate) {
        return new ReloadableCache<T>(delegate);
    }

    public static <T> ReloadableCache<T> of(ResourceKey<? extends Registry<T>> registry, ResourceLocation id) {
        return ReloadableCache.of((Level level) -> level.registryAccess().registryOrThrow(registry).get(id));
    }

    public static <T extends Recipe<?>> ReloadableCache<Map<ResourceLocation, RecipeHolder<T>>> of(RecipeType<T> type) {
        return ReloadableCache.of((Level level) -> {
            HashMap byId = new HashMap();
            RecipeManager patt0$temp = level.getRecipeManager();
            if (patt0$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt0$temp;
                Collection recipes = accessor.bookshelf$byTypeMap().get((Object)type);
                recipes.forEach(entry -> byId.put(entry.id(), entry));
            }
            return byId;
        });
    }

    public static <T extends Recipe<?>> ReloadableCache<Map<ResourceLocation, RecipeHolder<T>>> recipes(Supplier<RecipeType<T>> type) {
        return ReloadableCache.of((Level level) -> {
            HashMap byId = new HashMap();
            RecipeManager patt0$temp = level.getRecipeManager();
            if (patt0$temp instanceof AccessorRecipeManager) {
                AccessorRecipeManager accessor = (AccessorRecipeManager)patt0$temp;
                Collection recipes = accessor.bookshelf$byTypeMap().get((Object)((RecipeType)type.get()));
                recipes.forEach(entry -> byId.put(entry.id(), entry));
            }
            return byId;
        });
    }

    public static ReloadableCache<Entity> entity(CompoundTag entityData) {
        if (entityData == null || !entityData.contains("id", 8)) {
            throw new IllegalStateException("The provided entity data does not contain an entity ID! data=" + String.valueOf(entityData));
        }
        return ReloadableCache.of((Level level) -> {
            try {
                return EntityType.loadEntityRecursive((CompoundTag)entityData, (Level)level, Function.identity());
            }
            catch (Exception e) {
                throw new IllegalStateException("Encountered an error while constructing the target entity.", e);
            }
        });
    }

    public static ReloadableCache<LivingEntity> living(CompoundTag entityData) {
        ReloadableCache<Entity> entityCache = ReloadableCache.entity(entityData);
        return ReloadableCache.of((Level level) -> {
            Object patt0$temp = entityCache.apply((Level)level);
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                return living;
            }
            throw new IllegalStateException("Constructed entity was not a LivingEntity type. data=" + String.valueOf(entityData));
        });
    }

    @Override
    public int bookshelf$getRevision() {
        return this.revision;
    }

    @Override
    public void bookshelf$setRevision(int revision) {
        this.revision = revision;
    }
}

