/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.mixin.patch.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RecipeManager.class})
public class MixinRecipeManager {
    @Shadow
    private boolean hasErrors;
    @Shadow
    @Final
    private HolderLookup.Provider registries;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    private Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    @Shadow
    private Map<ResourceLocation, RecipeHolder<?>> byName;

    @Overwrite
    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.hasErrors = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        RegistryOps registryops = this.registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                Recipe recipe = (Recipe)Recipe.CODEC.parse((DynamicOps)registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder recipeholder = new RecipeHolder(resourcelocation, recipe);
                builder.put((Object)recipe.getType(), (Object)recipeholder);
                builder1.put((Object)resourcelocation, (Object)recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException var12) {
                LOGGER.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)var12);
            }
        }
        this.byType = builder.build();
        this.byName = builder1.build();
        LOGGER.info("Loaded {} recipes", (Object)this.byType.size());
    }
}

