/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.forge.impl;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.register.RegisterIngredient;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterVillagerTrades;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.BookshelfMod;
import net.darkhax.bookshelf.forge.impl.ForgeModClient;
import net.darkhax.bookshelf.forge.impl.data.ForgeIngredient;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="bookshelf")
public class ForgeMod {
    private final CachedSupplier<RegisterVillagerTrades> villagerTrades = CachedSupplier.cache(() -> {
        RegisterVillagerTrades register = new RegisterVillagerTrades();
        Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerTrades(register));
        return register;
    });

    public ForgeMod(FMLJavaModLoadingContext loadingContext) {
        BookshelfMod.getInstance().init();
        loadingContext.getModEventBus().addListener(this::onRegister);
        MinecraftForge.EVENT_BUS.addListener(this::registerVillagerTrades);
        MinecraftForge.EVENT_BUS.addListener(this::registerWandererTrades);
        if (Services.PLATFORM.isPhysicalClient()) {
            new ForgeModClient(loadingContext);
        }
    }

    private void onRegister(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.CREATIVE_MODE_TAB && event.getVanillaRegistry() != null) {
            BiConsumer<ResourceLocation, CreativeModeTab> registerFunc2 = (rl, tab) -> Registry.register((Registry)event.getVanillaRegistry(), (ResourceLocation)rl, (Object)tab);
            Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerItemTabs(new RegisterItemTab(provider.contentNamespace(), registerFunc2)));
        } else if (event.getRegistryKey() == ForgeRegistries.Keys.INGREDIENT_SERIALIZERS) {
            event.register(ForgeRegistries.Keys.INGREDIENT_SERIALIZERS, registerFunc -> Services.CONTENT_PROVIDERS.get().forEach(provider -> {
                RegisterIngredient registry = new RegisterIngredient(provider.contentNamespace(), (id, codec, stream) -> registerFunc.register(id, ForgeIngredient.makeIngredientType(id, codec, stream)));
                provider.registerIngredientTypes(registry);
            }));
        }
    }

    private void registerVillagerTrades(VillagerTradesEvent event) {
        Multimap<Integer, VillagerTrades.ItemListing> newTrades = this.villagerTrades.get().getVillagerTrades().get(event.getType());
        if (newTrades != null && !newTrades.isEmpty()) {
            Int2ObjectMap tradeData = event.getTrades();
            for (Map.Entry entry : newTrades.entries()) {
                ((List)tradeData.computeIfAbsent((Object)((Integer)entry.getKey()), ArrayList::new)).add((VillagerTrades.ItemListing)entry.getValue());
            }
        }
    }

    private void registerWandererTrades(WandererTradesEvent event) {
        this.villagerTrades.get().getCommonWanderingTrades().forEach(event.getGenericTrades()::add);
        this.villagerTrades.get().getRareWanderingTrades().forEach(event.getRareTrades()::add);
    }
}

