/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.commands.args.FontArgument;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBannerBlockEntity;
import net.darkhax.bookshelf.common.mixin.access.block.AccessorBaseContainerBlockEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public class FontCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder font = (LiteralArgumentBuilder)Commands.literal((String)"font").requires((Predicate)PermissionLevel.GAMEMASTER);
        LiteralArgumentBuilder rename = Commands.literal((String)"rename");
        rename.then(FontArgument.argument().executes(FontCommand::renameItemWithFont));
        rename.then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(FontArgument.argument().executes(FontCommand::renameItemWithFont)));
        font.then((ArgumentBuilder)rename);
        font.then(Commands.literal((String)"block").then(FontArgument.argument().then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(FontCommand::renameBlockWithFont))));
        font.then(Commands.literal((String)"say").then(FontArgument.argument().then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(FontCommand::speakWithFont))));
        return font;
    }

    private static int speakWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation fontId = FontArgument.get(context);
        Component inputMessage = TextHelper.applyFont(MessageArgument.getMessage(context, (String)"message"), fontId);
        MutableComponent txtMessage = Component.translatable((String)"chat.type.announcement", (Object[])new Object[]{((CommandSourceStack)context.getSource()).getDisplayName(), inputMessage});
        ((CommandSourceStack)context.getSource()).getServer().getPlayerList().broadcastSystemMessage((Component)txtMessage, false);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity target;
        ResourceLocation fontId = FontArgument.get(context);
        Entity entity = target = CommandHelper.hasArgument("target", context) ? EntityArgument.getEntity(context, (String)"target") : ((CommandSourceStack)context.getSource()).getEntity();
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            ItemStack stack = living.getMainHandItem();
            if (stack.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.bookshelf.hand.error.not_air"));
                return 0;
            }
            stack.set(DataComponents.CUSTOM_NAME, (Object)TextHelper.applyFont((Component)stack.getHoverName().copy(), fontId));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.bookshelf.font.bad_sender"));
        return 0;
    }

    private static int renameBlockWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        ResourceLocation fontId = FontArgument.get(context);
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && tile.hasLevel()) {
            BlockEntity blockEntity = tile;
            Objects.requireNonNull(blockEntity);
            BlockEntity blockEntity2 = blockEntity;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BaseContainerBlockEntity.class, SignBlockEntity.class, BannerBlockEntity.class}, (Object)blockEntity2, n)) {
                    case 0: {
                        BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity2;
                        if (!(tile instanceof AccessorBaseContainerBlockEntity)) {
                            n = 1;
                            continue block5;
                        }
                        AccessorBaseContainerBlockEntity accessor = (AccessorBaseContainerBlockEntity)tile;
                        accessor.bookshelf$name(TextHelper.applyFont((Component)container.getName().copy(), fontId));
                        break block5;
                    }
                    case 1: {
                        SignBlockEntity sign = (SignBlockEntity)blockEntity2;
                        sign.updateText(FontCommand.applySignFont(fontId), true);
                        sign.updateText(FontCommand.applySignFont(fontId), false);
                        sign.getLevel().sendBlockUpdated(sign.getBlockPos(), sign.getBlockState(), sign.getBlockState(), 3);
                        break block5;
                    }
                    case 2: {
                        BannerBlockEntity banner = (BannerBlockEntity)blockEntity2;
                        if (!banner.hasCustomName() || !(banner instanceof AccessorBannerBlockEntity)) {
                            n = 3;
                            continue block5;
                        }
                        AccessorBannerBlockEntity accessor = (AccessorBannerBlockEntity)banner;
                        accessor.setName(TextHelper.applyFont(banner.getCustomName(), fontId));
                        break block5;
                    }
                    default: {
                        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.bookshelf.font.unsupported_block", (Object[])new Object[]{tile.getBlockState().getBlock().getName()}));
                        break block5;
                    }
                }
                break;
            }
        }
        return 1;
    }

    private static UnaryOperator<SignText> applySignFont(ResourceLocation fontId) {
        return text -> {
            SignText newText = text;
            for (int i = 0; i < 4; ++i) {
                newText = newText.setMessage(i, TextHelper.applyFont((Component)text.getMessage(i, false).copy(), fontId));
            }
            return newText;
        };
    }
}

