/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.forge.impl.data;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.ingredient.IngredientLogic;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeIngredient<T extends IngredientLogic<T>>
extends AbstractIngredient {
    private final T logic;
    private final Supplier<IIngredientSerializer<?>> type;

    public ForgeIngredient(T logic, Supplier<IIngredientSerializer<?>> type) {
        this.logic = logic;
        this.type = type;
    }

    public boolean test(ItemStack stack) {
        return this.logic.test(stack);
    }

    public boolean isSimple() {
        return !this.logic.requiresTesting();
    }

    public ItemStack[] getItems() {
        return (ItemStack[])this.logic.getAllMatchingStacks().toArray(ItemStack[]::new);
    }

    public boolean isEmpty() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        return this.type.get();
    }

    public static <T extends IngredientLogic<T>> IIngredientSerializer<ForgeIngredient<T>> makeIngredientType(ResourceLocation id, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> stream) {
        Supplier<IIngredientSerializer> typeLookup = () -> (IIngredientSerializer)ForgeRegistries.INGREDIENT_SERIALIZERS.get().getValue(id);
        final MapCodec ingredientCodec = codec.xmap(l -> new ForgeIngredient<IngredientLogic>((IngredientLogic)l, (Supplier<IIngredientSerializer<?>>)typeLookup), i -> i.logic);
        final StreamCodec ingredientStream = stream.map(l -> new ForgeIngredient<IngredientLogic>((IngredientLogic)l, (Supplier<IIngredientSerializer<?>>)typeLookup), i -> i.logic);
        return new IIngredientSerializer<ForgeIngredient<T>>(){

            public MapCodec<? extends ForgeIngredient<T>> codec() {
                return ingredientCodec;
            }

            public void write(RegistryFriendlyByteBuf buffer, ForgeIngredient<T> value) {
                ingredientStream.encode((Object)buffer, value);
            }

            public ForgeIngredient<T> read(RegistryFriendlyByteBuf buffer) {
                return (ForgeIngredient)((Object)ingredientStream.decode((Object)buffer));
            }
        };
    }
}

