/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import net.darkhax.bookshelf.common.api.commands.IEnumCommand;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.bookshelf.common.api.util.CommandHelper;
import net.darkhax.bookshelf.common.api.util.TextHelper;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.bookshelf.common.impl.data.loot.modifiers.ILootPoolHooks;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootTable;
import net.minecraft.class_1074;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_55;
import net.minecraft.class_7157;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public enum DebugCommands implements IEnumCommand
{
    MISSING_TAG_NAMES(DebugCommands::findMissingTagNames),
    MISSING_BLOCK_DROPS(DebugCommands::findMissingBlockDrops),
    LOOT_POOL_HASH(DebugCommands::findLootTableHashes),
    SIMPLE_TABLES(DebugCommands::printTables);

    private final DebugTask debugTask;

    private static void printTables(MinecraftServer server, StringJoiner out) {
        Collection tableKeys = server.method_58576().method_58290(class_7924.field_50079);
        class_5455.class_6890 registries = server.method_58576().method_58289();
        for (class_2960 tableKey : tableKeys) {
            class_52 table = server.method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)tableKey));
            out.add(String.valueOf(tableKey) + " = " + String.valueOf(LootPoolEntryDescriptions.getUniqueItems((class_5455)registries, table)));
        }
    }

    private static void findMissingTagNames(MinecraftServer server, StringJoiner out) {
        server.method_30611().method_40311().forEach(entry -> {
            AtomicBoolean hasLogged = new AtomicBoolean(false);
            entry.comp_351().method_40273().forEach(tag -> {
                if (!tag.comp_327().method_12836().equals("minecraft") && !class_1074.method_4663((String)TextHelper.getTagName(tag))) {
                    if (!hasLogged.get()) {
                        hasLogged.set(true);
                        out.add("## " + String.valueOf(entry.comp_350().method_29177()));
                    }
                    out.add("\"" + TextHelper.getTagName(tag) + "\": \"\",");
                }
            });
            if (hasLogged.get()) {
                out.add("");
            }
        });
    }

    private static void findMissingBlockDrops(MinecraftServer server, StringJoiner out) {
        class_7871 lootTables = (class_7871)server.method_58576().method_58294().method_46750(class_7924.field_50079).orElseThrow();
        for (class_2248 block : class_7923.field_41175) {
            Optional result = lootTables.method_46746(block.method_26162());
            if (!result.isEmpty()) continue;
            class_2960 id = block.method_26162().method_29177();
            out.add(String.valueOf(class_7923.field_41175.method_10221((Object)block)) + " - " + String.valueOf(id) + " - data/" + id.method_12836() + "/loot_table/" + id.method_12832());
        }
    }

    private static void findLootTableHashes(MinecraftServer server, StringJoiner out) {
        class_7871 lootTables = (class_7871)server.method_58576().method_58294().method_46750(class_7924.field_50079).orElseThrow();
        for (class_2960 table : server.method_58576().method_58290(class_7924.field_50079)) {
            if (!table.method_12832().startsWith("chests") && !table.method_12832().startsWith("dispensers") && !table.method_12832().startsWith("gameplay") && !table.method_12832().startsWith("pots") && !table.method_12832().startsWith("spawners")) continue;
            out.add("## " + table.toString());
            lootTables.method_46746(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)table)).ifPresent(val -> {
                Object patt0$temp = val.comp_349();
                if (patt0$temp instanceof AccessorLootTable) {
                    AccessorLootTable accessor = (AccessorLootTable)patt0$temp;
                    for (int index = 0; index < accessor.bookshelf$pools().size(); ++index) {
                        class_55 patt1$temp = accessor.bookshelf$pools().get(index);
                        if (!(patt1$temp instanceof ILootPoolHooks)) continue;
                        ILootPoolHooks fingerprintable = (ILootPoolHooks)patt1$temp;
                        out.add("- " + index + " | " + fingerprintable.bookshelf$getHash());
                    }
                }
            });
        }
    }

    public static LiteralArgumentBuilder<class_2168> build(class_7157 context) {
        return CommandHelper.buildFromEnum("debug", DebugCommands.class);
    }

    private DebugCommands(DebugTask task) {
        this.debugTask = task;
    }

    @Override
    public String getCommandName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        this.debugTask.getDebugOutput(((class_2168)context.getSource()).method_9211(), joiner);
        Constants.LOG.warn(joiner.toString());
        String debugInfo = joiner.toString();
        if (debugInfo.isBlank()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.bookshelf.debug.no_info"));
            return 0;
        }
        if (debugInfo.length() > 10000) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.bookshelf.debug.too_long"));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> TextHelper.setCopyText(class_2561.method_43471((String)"commands.bookshelf.debug.yes_info"), debugInfo), false);
        return 1;
    }

    @Override
    public PermissionLevel requiredPermissionLevel() {
        return PermissionLevel.OWNER;
    }

    @FunctionalInterface
    public static interface DebugTask {
        public void getDebugOutput(MinecraftServer var1, StringJoiner var2);
    }
}

