/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.loot;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriber;
import net.darkhax.bookshelf.common.api.registry.register.RegisterLootDescription;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.data.loot.entries.LootItemStack;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorCompositeEntryBase;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootItem;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootPool;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorLootTable;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorNestedLootTable;
import net.darkhax.bookshelf.common.mixin.access.loot.AccessorTagEntry;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5338;
import net.minecraft.class_5455;
import net.minecraft.class_55;
import net.minecraft.class_67;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_73;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class LootPoolEntryDescriptions {
    private static final CachedSupplier<class_1799> UNKNOWN_ITEM_DISPLAY = CachedSupplier.cache(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8615);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"tooltips.bookshelf.loot.unknown"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43471((String)"tooltips.bookshelf.loot.unknown.desc").method_27692(class_124.field_1080))));
        return stack;
    });
    private static final CachedSupplier<class_1799> EMPTY_ITEM_DISPLAY = CachedSupplier.cache(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8077);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"tooltips.bookshelf.loot.empty"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43471((String)"tooltips.bookshelf.loot.empty.desc").method_27692(class_124.field_1080))));
        return stack;
    });
    private static final CachedSupplier<class_1799> DYNAMIC_DISPLAY = CachedSupplier.cache(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_16538);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)"tooltips.bookshelf.loot.dynamic"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43471((String)"tooltips.bookshelf.loot.dynamic.desc").method_27692(class_124.field_1080))));
        return stack;
    });
    private static final Map<class_5338, LootPoolEntryDescriber> DESCRIBERS = new HashMap<class_5338, LootPoolEntryDescriber>();
    private static boolean hasInitialized = false;
    public static final LootPoolEntryDescriber EMPTY = (server, entry, collector) -> {
        if (entry instanceof class_73) {
            collector.accept(EMPTY_ITEM_DISPLAY.get());
        }
    };
    public static final LootPoolEntryDescriber ITEM = (server, entry, collector) -> {
        if (entry instanceof AccessorLootItem) {
            AccessorLootItem accessor = (AccessorLootItem)entry;
            collector.accept(new class_1799(accessor.bookshelf$item()));
        }
    };
    public static final LootPoolEntryDescriber LOOT_TABLE = (server, entry, collector) -> {
        if (entry instanceof AccessorNestedLootTable) {
            AccessorNestedLootTable accessor = (AccessorNestedLootTable)entry;
            LootPoolEntryDescriptions.getPotentialItems(server, accessor.bookshelf$contents(), (Consumer<class_1799>)collector);
        }
    };
    public static final LootPoolEntryDescriber DYNAMIC = (server, entry, collector) -> {
        if (entry instanceof class_67) {
            collector.accept(DYNAMIC_DISPLAY.get());
        }
    };
    public static final LootPoolEntryDescriber TAG = (server, entry, collector) -> {
        if (entry instanceof AccessorTagEntry) {
            AccessorTagEntry tagEntry = (AccessorTagEntry)entry;
            LootPoolEntryDescriptions.getTagItems(tagEntry.bookshelf$tag(), collector);
        }
    };
    public static final LootPoolEntryDescriber COMPOSITE = (server, entry, collector) -> {
        if (entry instanceof AccessorCompositeEntryBase) {
            AccessorCompositeEntryBase accessor = (AccessorCompositeEntryBase)entry;
            LootPoolEntryDescriptions.getPotentialItems(server, accessor.bookshelf$children(), (Consumer<class_1799>)collector);
        }
    };
    public static final LootPoolEntryDescriber ITEM_STACK = (server, entry, collector) -> {
        if (entry instanceof LootItemStack) {
            LootItemStack loot = (LootItemStack)entry;
            collector.accept(loot.getBaseStack());
        }
    };

    private static void bootstrap() {
        if (!hasInitialized) {
            RegisterLootDescription register = new RegisterLootDescription(DESCRIBERS::put);
            Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerLootDescriptions(register));
            hasInitialized = true;
        }
    }

    public static List<class_1799> getUniqueItems(@NotNull class_5455 registries, class_52 table) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        LootPoolEntryDescriptions.getPotentialItems(registries, table, (class_1799 stack) -> LootPoolEntryDescriptions.addStacking(items, stack));
        return items;
    }

    public static void getPotentialItems(@NotNull class_5455 registries, Either<class_5321<class_52>, class_52> table, Consumer<class_1799> consumer) {
        class_52 resolved = (class_52)table.map(rl -> (class_52)registries.method_30530(class_7924.field_50079).method_29107(rl), Function.identity());
        if (resolved != null) {
            LootPoolEntryDescriptions.getPotentialItems(registries, resolved, consumer);
        }
    }

    public static void getPotentialItems(@NotNull class_5455 registries, class_52 table, Consumer<class_1799> consumer) {
        if (table instanceof AccessorLootTable) {
            AccessorLootTable tableAccess = (AccessorLootTable)table;
            for (class_55 pool : tableAccess.bookshelf$pools()) {
                if (!(pool instanceof AccessorLootPool)) continue;
                AccessorLootPool poolAccess = (AccessorLootPool)pool;
                LootPoolEntryDescriptions.getPotentialItems(registries, poolAccess.bookshelf$entries(), consumer);
            }
        }
    }

    public static void getPotentialItems(@NotNull class_5455 registries, List<class_79> entries, Consumer<class_1799> collector) {
        for (class_79 entry : entries) {
            LootPoolEntryDescriptions.getPotentialItems(registries, entry, collector);
        }
    }

    public static void getPotentialItems(@NotNull class_5455 registries, class_79 entry, Consumer<class_1799> collector) {
        LootPoolEntryDescriptions.bootstrap();
        LootPoolEntryDescriber describer = DESCRIBERS.get(entry.method_29318());
        if (describer != null) {
            describer.getPotentialDrops(registries, entry, collector);
        } else {
            collector.accept(UNKNOWN_ITEM_DISPLAY.get());
        }
    }

    private static void addStacking(List<class_1799> items, class_1799 toAdd) {
        for (class_1799 existing : items) {
            if (!Objects.equals(existing, toAdd) && !class_1799.method_31577((class_1799)existing, (class_1799)toAdd)) continue;
            return;
        }
        items.add(toAdd);
    }

    private static void getTagItems(class_6862<class_1792> tag, Consumer<class_1799> collector) {
        for (class_6880 item : class_7923.field_41178.method_40286(tag)) {
            collector.accept(new class_1799(item));
        }
    }
}

