package net.darkhax.bookshelf.fabric.impl;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.darkhax.bookshelf.common.api.registry.register.RegisterIngredient;
import net.darkhax.bookshelf.common.api.registry.register.RegisterVillagerTrades;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.BookshelfMod;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.bookshelf.fabric.impl.data.FabricIngredient;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_3797;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FabricMod implements ModInitializer {

    @Override
    public void onInitialize() {
        BookshelfMod.getInstance().init();
        this.registerVillagerTrades();
        this.registerIngredientTypes();
        checkForUpdates();
    }

    private void registerIngredientTypes() {
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            final RegisterIngredient registry = new RegisterIngredient(provider.contentNamespace(), (id, codec, stream) -> CustomIngredientSerializer.register(FabricIngredient.make(id, codec, stream)));
            provider.registerIngredientTypes(registry);
        });
    }

    private void registerVillagerTrades() {
        final RegisterVillagerTrades register = new RegisterVillagerTrades();
        Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerTrades(register));
        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : register.getVillagerTrades().entrySet()) {
            final Int2ObjectMap<class_3853.class_1652[]> professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap<>());
            for (int merchantTier : professionData.getValue().keySet()) {
                final List<class_3853.class_1652> tradesForTier = new ArrayList<>(Arrays.asList(professionTrades.getOrDefault(merchantTier, new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get(merchantTier));
                professionTrades.put(merchantTier, tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
        final List<class_3853.class_1652> commonTrades = register.getCommonWanderingTrades();
        if (!commonTrades.isEmpty()) {
            final List<class_3853.class_1652> tradeData = new ArrayList<>(Arrays.asList(class_3853.field_17724.get(1)));
            tradeData.addAll(commonTrades);
            class_3853.field_17724.put(1, tradeData.toArray(new class_3853.class_1652[0]));
        }
        final List<class_3853.class_1652> rareTrades = register.getRareWanderingTrades();
        if (!rareTrades.isEmpty()) {
            final List<class_3853.class_1652> tradeData = new ArrayList<>(Arrays.asList(class_3853.field_17724.get(2)));
            tradeData.addAll(rareTrades);
            class_3853.field_17724.put(2, tradeData.toArray(new class_3853.class_1652[0]));
        }
    }

    private static void checkForUpdates() {
        try {
            final HttpURLConnection connection = (HttpURLConnection) new URL("https://updates.blamejared.com/get?n=" + Constants.MOD_ID + "&gv=" + class_3797.field_25319.method_48019() + "&ml=fabric").openConnection();
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Constants.LOG.warn("Version checker is not available.");
            }
        }
        catch (Exception e) {
            // TODO
        }
    }
}