package net.darkhax.bookshelf.common.mixin.patch.registries;

import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterPacket;
import net.darkhax.bookshelf.common.api.registry.register.RegisterParticleTypes;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.mixin.access.particles.AccessSimpleParticleType;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_7923.class)
public class MixinBuiltInRegistries {

    @Inject(method = "bootStrap()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/core/registries/BuiltInRegistries;freeze()V", ordinal = 0))
    private static void bootstrap(CallbackInfo callback) {
        // TODO consider moving this to a different location later
        Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            provider.registerLoadConditions(new Register<>(provider.contentNamespace(), LoadConditions::register));
            provider.registerPackets(new RegisterPacket(provider.contentNamespace(), Services.NETWORK::register));
            provider.registerParticleTypes(new RegisterParticleTypes(provider.contentNamespace(), (id, overrideLimit) -> {
                final class_2400 particleType = AccessSimpleParticleType.init(overrideLimit);
                class_2378.method_10230(class_7923.field_41180, id, particleType);
                return () -> particleType;
            }));
        });
    }
}