package net.darkhax.bookshelf.common.impl.data.loot.entries;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.impl.Constants;
import net.minecraft.class_117;
import net.minecraft.class_1799;
import net.minecraft.class_47;
import net.minecraft.class_5338;
import net.minecraft.class_5341;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * A LootPool entry type that produces copies of predefined ItemStack.
 */
public class LootItemStack extends class_85 {

    private static final Supplier<class_5338> TYPE = CachedSupplier.of(class_7923.field_41133, Constants.id("item_stack"));
    public static final MapCodec<LootItemStack> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(MapCodecs.ITEM_STACK.get("item", LootItemStack::getBaseStack))
            .and(method_53290(instance))
            .apply(instance, LootItemStack::new)
    );

    private final class_1799 baseStack;

    private LootItemStack(class_1799 baseStack, int weight, int quality, List<class_5341> conditions, List<class_117> functions) {
        super(weight, quality, conditions, functions);
        this.baseStack = baseStack;
    }

    public class_1799 getBaseStack() {
        return this.baseStack.method_7972();
    }

    @Override
    protected void method_433(Consumer<class_1799> consumer, @NotNull class_47 context) {
        consumer.accept(this.baseStack.method_7972());
    }

    @NotNull
    @Override
    public class_5338 method_29318() {
        return TYPE.get();
    }

    public static LootItemStack of(class_1799 baseStack, int weight) {
        return new LootItemStack(baseStack, weight, 0, List.of(), List.of());
    }

    public static LootItemStack of(class_1799 baseStack, int weight, int quality, List<class_5341> conditions, List<class_117> functions) {
        return new LootItemStack(baseStack, weight, quality, conditions, functions);
    }
}
