package net.darkhax.bookshelf.common.impl.data.ingredient;

import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.ingredient.IngredientLogic;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;

public class BlockTagIngredient implements IngredientLogic<BlockTagIngredient> {

    public static final MapCodec<BlockTagIngredient> CODEC = MapCodecs.flexibleList(class_6862.method_40090(class_7924.field_41254)).xmap(BlockTagIngredient::new, l -> l.blockTags).fieldOf("tag");
    public static final class_9139<class_9129, BlockTagIngredient> STREAM = class_9139.method_56437(
            (buf, val) -> buf.method_34062(val.blockTags, (b1, tag) -> {
                b1.method_10812(tag.comp_327());
            }),
            buf -> new BlockTagIngredient(buf.method_34068(ArrayList::new, b1 -> class_6862.method_40092(class_7924.field_41254, b1.method_10810())))
    );

    private final List<class_6862<class_2248>> blockTags;
    private List<class_1799> matches;

    public BlockTagIngredient(List<class_6862<class_2248>> blockTags) {
        this.blockTags = blockTags;
    }

    @Override
    public List<class_1799> getAllMatchingStacks() {
        if (this.matches == null) {
            this.matches = new ArrayList<>();
            for (class_6862<class_2248> tag : blockTags) {
                for (class_6880<class_2248> entry : class_7923.field_41175.method_40286(tag)) {
                    final class_1799 stack = new class_1799(entry.comp_349());
                    if (!stack.method_7960()) {
                        this.matches.add(stack);
                    }
                }
            }
        }
        return this.matches;
    }

    @Override
    public boolean test(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        for (class_1799 valid : this.getAllMatchingStacks()) {
            if (valid.method_7909() == stack.method_7909()) {
                return true;
            }
        }
        return false;
    }
}