package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StructureCommand {

    public static LiteralArgumentBuilder<class_2168> build() {
        final LiteralArgumentBuilder<class_2168> root = class_2170.method_9247("structure").requires(PermissionLevel.GAMEMASTER);
        root.executes(withPosition(StructureCommand::structureAt, ctx -> ctx.getSource().method_9228().method_24515()));
        root.then(class_2170.method_9244("position", class_2262.method_9698()).executes(withPosition(StructureCommand::structureAt, ctx -> class_2262.method_48299(ctx, "position"))));
        return root;
    }

    private static Set<class_2960> getUniqueStructuresAt(CommandContext<class_2168> context, class_2338 pos) {
        final class_3218 level = context.getSource().method_9225();
        final class_2378<class_3195> registry = level.method_30349().method_30530(class_7924.field_41246);
        return level.method_27056().method_41035(new class_1923(pos), s -> true).stream().filter(s -> s.method_14969().method_14662(pos)).map(s -> registry.method_10221(s.method_16656())).collect(Collectors.toSet());
    }

    private static int structureAt(CommandContext<class_2168> context, class_2338 pos) {
        final Set<class_2960> structures = getUniqueStructuresAt(context, pos);
        if (structures.isEmpty()) {
            context.getSource().method_9213(class_2561.method_43471("commands.bookshelf.structure.error.no_structures"));
        }
        else {
            context.getSource().method_9226(() -> class_2561.method_43469("commands.bookshelf.structure.found", structures.size()).method_10852(class_2561.method_43470("\n  " + structures.stream().map(class_2960::toString).collect(Collectors.joining("\n  ")))), false);
        }
        return structures.size();
    }

    private static Command<class_2168> withPosition(BiFunction<CommandContext<class_2168>, class_2338, Integer> cmd, Function<CommandContext<class_2168>, class_2338> provider) {
        return ctx -> cmd.apply(ctx, provider.apply(ctx));
    }
}